/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.nls.formatter.impl.plugin;

import io.github.mmm.base.i18n.Localizable;
import io.github.mmm.base.i18n.LocalizableObject;
import io.github.mmm.nls.NlsMessage;
import io.github.mmm.nls.NlsMessageFactory;
import io.github.mmm.nls.argument.NlsArguments;
import io.github.mmm.nls.formatter.impl.plugin.AbstractNlsFormatterPlugin;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;

public class NlsFormatterPluginDefault
extends AbstractNlsFormatterPlugin {
    @Override
    public void doFormat(Object object, Locale locale, NlsArguments arguments, Appendable buffer) throws IOException {
        String result = null;
        if (object != null) {
            if (object instanceof Number) {
                result = NumberFormat.getInstance(locale).format(object);
            } else if (object instanceof Date) {
                DateFormat format = DateFormat.getDateTimeInstance(3, 1, locale);
                result = format.format(object);
            } else if (object instanceof LocalizableObject) {
                Localizable message = ((LocalizableObject)object).toLocalizable();
                if (message != null) {
                    message.getLocalizedMessage(locale, buffer);
                    return;
                }
            } else if (object instanceof Class) {
                result = ((Class)object).getName();
            } else {
                if (object instanceof Enum) {
                    Enum enumValue = (Enum)object;
                    Class type = enumValue.getDeclaringClass();
                    NlsMessage message = NlsMessageFactory.get().create(Localizable.createBundleName(type), enumValue.name(), object.toString());
                    message.getLocalizedMessage(locale, buffer);
                    return;
                }
                result = object.toString();
            }
        }
        if (result == null) {
            result = "null";
        }
        buffer.append(result);
    }

    @Override
    public String getStyle() {
        return null;
    }

    @Override
    public String getType() {
        return null;
    }
}

