/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.nls.formatter.impl.plugin;

import io.github.mmm.nls.argument.NlsArguments;
import io.github.mmm.nls.formatter.impl.plugin.AbstractNlsFormatterPlugin;
import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Locale;

public class NlsFormatterPluginType
extends AbstractNlsFormatterPlugin {
    private static final Package PACKAGE_JAVA_LANG = Package.class.getPackage();
    private final String style;

    public NlsFormatterPluginType(String style) {
        this.style = style;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public String getType() {
        return "type";
    }

    @Override
    public void doFormat(Object object, Locale locale, NlsArguments arguments, Appendable buffer) throws IOException {
        if (object == null) {
            buffer.append("null");
        } else if (object instanceof Type) {
            this.doFormat((Type)object, buffer);
        } else {
            buffer.append(object.toString());
        }
    }

    private void doFormat(Type type, Appendable appendable) throws IOException {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (this.style.equals("short")) {
                appendable.append(clazz.getSimpleName());
            } else if (this.style.equals("long") || this.style.equals("medium")) {
                if (PACKAGE_JAVA_LANG.equals(clazz.getPackage())) {
                    appendable.append(clazz.getSimpleName());
                } else {
                    appendable.append(clazz.getCanonicalName());
                }
            } else {
                appendable.append(clazz.getCanonicalName());
            }
        } else if (type instanceof ParameterizedType) {
            Type ownerType;
            boolean longOrFullStyle;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            boolean bl = longOrFullStyle = this.style.equals("long") || this.style.equals("full");
            if (longOrFullStyle && (ownerType = parameterizedType.getOwnerType()) != null) {
                this.doFormat(ownerType, appendable);
                appendable.append('.');
            }
            this.doFormat(parameterizedType.getRawType(), appendable);
            if (longOrFullStyle) {
                appendable.append('<');
                boolean separator = false;
                for (Type arg : parameterizedType.getActualTypeArguments()) {
                    if (separator) {
                        appendable.append(", ");
                    }
                    this.doFormat(arg, appendable);
                    separator = true;
                }
                appendable.append('>');
            }
        } else if (type instanceof TypeVariable) {
            Type firstBound;
            TypeVariable typeVariable = (TypeVariable)type;
            appendable.append(typeVariable.getName());
            Type[] bounds = typeVariable.getBounds();
            if (bounds.length > 0 && !Object.class.equals((Object)(firstBound = bounds[0]))) {
                appendable.append(" extends ");
                this.doFormat(firstBound, appendable);
            }
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] lowerBounds = wildcardType.getLowerBounds();
            if (lowerBounds.length > 0) {
                appendable.append("? super ");
                this.doFormat(lowerBounds[0], appendable);
            } else {
                Type[] upperBounds = wildcardType.getUpperBounds();
                if (upperBounds.length > 0) {
                    appendable.append("? extends ");
                    this.doFormat(upperBounds[0], appendable);
                } else {
                    appendable.append("?");
                }
            }
        } else if (type instanceof GenericArrayType) {
            this.doFormat(((GenericArrayType)type).getGenericComponentType(), appendable);
            appendable.append("[]");
        } else {
            appendable.append(type.toString());
        }
    }
}

