/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.nls.impl;

import io.github.mmm.base.exception.RuntimeIoException;
import io.github.mmm.nls.argument.NlsArguments;
import io.github.mmm.nls.descriptor.NlsMessageDescriptor;
import io.github.mmm.nls.formatter.impl.NlsMessageFormatterImpl;
import io.github.mmm.nls.impl.AbstractNlsMessage;
import io.github.mmm.nls.template.NlsTemplate;
import io.github.mmm.nls.template.impl.NlsTemplateImpl;
import java.io.IOException;
import java.util.Locale;

public class NlsMessageImpl
extends AbstractNlsMessage {
    private NlsTemplateImpl template;
    private String internationalizedMessage;
    private NlsArguments arguments;

    public NlsMessageImpl(NlsTemplateImpl template, String internationalizedMessage, NlsArguments arguments) {
        this.template = template;
        this.internationalizedMessage = internationalizedMessage;
        this.arguments = arguments == null ? NlsArguments.of() : arguments;
    }

    @Override
    public NlsArguments getArguments() {
        return this.arguments;
    }

    @Override
    public String getInternationalizedMessage() {
        if (this.internationalizedMessage == null) {
            this.internationalizedMessage = this.template.translate(Locale.ROOT);
        }
        return this.internationalizedMessage;
    }

    public NlsTemplate getTemplate() {
        return this.template;
    }

    @Override
    public NlsMessageDescriptor getDescriptor() {
        return this.template;
    }

    public void getLocalizedMessage(Locale locale, Appendable buffer) {
        Locale actualLocale = locale;
        if (actualLocale == null) {
            actualLocale = Locale.ROOT;
        }
        try {
            if (this.arguments.isEmpty()) {
                String text = this.template.translate(actualLocale);
                if (text == null) {
                    text = this.internationalizedMessage;
                }
                buffer.append(text);
            } else {
                boolean success = false;
                success = this.template.translate(actualLocale, this.arguments, buffer);
                if (!success) {
                    NlsMessageFormatterImpl format = new NlsMessageFormatterImpl(this.internationalizedMessage);
                    format.format(null, actualLocale, this.arguments, buffer);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e);
        }
    }
}

