/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.nls.template.impl;

import io.github.mmm.base.exception.RuntimeIoException;
import io.github.mmm.nls.argument.NlsArguments;
import io.github.mmm.nls.descriptor.NlsMessageDescriptor;
import io.github.mmm.nls.formatter.NlsMessageFormatter;
import io.github.mmm.nls.formatter.NlsMessageFormatterFactory;
import io.github.mmm.nls.template.NlsTemplate;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NlsTemplateImpl
implements NlsTemplate,
NlsMessageDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger(NlsTemplateImpl.class);
    private final String bundleName;
    private final String messageKey;

    public NlsTemplateImpl(String name, String key) {
        this.bundleName = name;
        this.messageKey = key;
    }

    @Override
    public String getBundleName() {
        return this.bundleName;
    }

    @Override
    public String getMessageKey() {
        return this.messageKey;
    }

    @Override
    public String translate(Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.bundleName, locale);
            return bundle.getString(this.messageKey);
        }
        catch (Exception e) {
            return this.translateFallback(e);
        }
    }

    @Override
    public boolean translate(Locale locale, NlsArguments arguments, Appendable buffer) {
        String translation = this.translate(locale);
        if (translation == null) {
            return false;
        }
        try {
            NlsMessageFormatter formatter = NlsMessageFormatterFactory.get().create(translation);
            formatter.format(null, locale, arguments, buffer);
            return true;
        }
        catch (Exception e) {
            try {
                LOG.info("Invalid NLS message {}", (Object)translation, (Object)e);
                buffer.append(translation);
                buffer.append("@");
                buffer.append(arguments.toString());
                return true;
            }
            catch (IOException e1) {
                throw new RuntimeIoException((Throwable)e1);
            }
        }
    }

    protected String translateFallback(Exception e) {
        String messageId = this.bundleName + ":" + this.messageKey;
        if (e instanceof MissingResourceException) {
            e = null;
        }
        LOG.info("Failed to resolve message {}:{}", new Object[]{this.bundleName, this.messageKey, e});
        return this.translateFallback(messageId);
    }

    protected String translateFallback(String messageId) {
        return "unresolved (" + messageId + ")";
    }

    public String toString() {
        return this.bundleName + ":" + this.messageKey;
    }
}

