/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.nls.variable.impl;

import io.github.mmm.base.filter.CharFilter;
import io.github.mmm.base.filter.ListCharFilter;
import io.github.mmm.base.justification.Justification;
import io.github.mmm.nls.formatter.NlsFormatterManager;
import io.github.mmm.nls.formatter.NlsFormatterPlugin;
import io.github.mmm.nls.variable.NlsVariable;
import io.github.mmm.nls.variable.NlsVariableParser;
import io.github.mmm.scanner.CharSequenceScanner;

public class NlsVariableParserImpl
implements NlsVariableParser {
    public static final NlsVariableParserImpl INSTANCE = new NlsVariableParserImpl();
    protected static final CharFilter NO_COMMA_OR_END_EXPRESSION = new ListCharFilter(",}").negate();
    protected static final CharFilter NO_EXPRESSION = new ListCharFilter("{}").negate();

    @Override
    public NlsVariable parse(CharSequenceScanner scanner) {
        NlsFormatterManager formatterManager = NlsFormatterManager.get();
        String key = scanner.readWhile(CharFilter.IDENTIFIER);
        int cp = scanner.next();
        int index = scanner.getCurrentIndex();
        String formatType = null;
        NlsFormatterPlugin formatter = null;
        if (cp == 44) {
            formatType = scanner.readWhile(NO_COMMA_OR_END_EXPRESSION);
            index = scanner.getCurrentIndex();
            cp = scanner.next();
            if (cp == 44) {
                index = scanner.getCurrentIndex();
                try {
                    formatter = formatterManager.getFormatter(formatType, scanner);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to parse '" + scanner.substring(index, scanner.getCurrentIndex()) + "' as NlsFormatter.", e);
                }
                cp = scanner.next();
            } else {
                formatter = formatterManager.getFormatter(formatType);
            }
        }
        Justification justification = null;
        if (cp == 123) {
            String formatJustification = scanner.readUntil(125, false);
            justification = Justification.of((String)formatJustification);
            cp = scanner.next();
        }
        if (cp != 125) {
            throw new IllegalArgumentException(scanner.substring(index, scanner.getCurrentIndex()));
        }
        if (formatter == null) {
            formatter = formatterManager.getFormatter();
        }
        return new NlsVariable(key, formatter, justification);
    }
}

