/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.orm.connection;

import io.github.mmm.base.metainfo.MetaInfo;
import io.github.mmm.orm.connection.DbConnectionPool;
import io.github.mmm.orm.connection.impl.DbConnectionDataManager;
import io.github.mmm.orm.dialect.DbDialect;
import io.github.mmm.orm.source.DbSource;

public interface DbConnectionData {
    public DbDialect getDialect();

    public DbSource getSource();

    public MetaInfo getConfig();

    default public String getUrl() {
        return this.getConfig().getRequired("url");
    }

    default public String getUser() {
        return this.getConfig().getRequired("user");
    }

    default public String getPassword() {
        return this.getConfig().getRequired("password");
    }

    default public String getKind() {
        return this.getConfig().get("kind");
    }

    public DbConnectionPool<?> getPool();

    public static DbConnectionData of(DbSource source) {
        return DbConnectionDataManager.INSTANCE.getOrCreate(source);
    }
}

