/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.orm.connection.impl;

import io.github.mmm.base.exception.ObjectNotFoundException;
import io.github.mmm.base.metainfo.MetaInfo;
import io.github.mmm.orm.connection.DbConnectionData;
import io.github.mmm.orm.connection.DbConnectionPool;
import io.github.mmm.orm.connection.DbConnectionPoolProvider;
import io.github.mmm.orm.connection.DbConnectionPoolProviderManager;
import io.github.mmm.orm.connection.impl.DbConnectionDataImpl;
import io.github.mmm.orm.dialect.AbstractDbDialect;
import io.github.mmm.orm.dialect.DbDialect;
import io.github.mmm.orm.dialect.DbDialectProvider;
import io.github.mmm.orm.source.DbSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbConnectionDataManager {
    private static final Logger LOG = LoggerFactory.getLogger(DbConnectionDataManager.class);
    public static final DbConnectionDataManager INSTANCE = new DbConnectionDataManager();
    private final Map<String, DbConnectionDataImpl> data = new ConcurrentHashMap<String, DbConnectionDataImpl>();

    private DbConnectionDataManager() {
    }

    public DbConnectionData get(DbSource source) {
        return this.data.get(source.getId());
    }

    public DbConnectionData getOrCreate(DbSource source) {
        return this.data.computeIfAbsent(source.getId(), k -> this.create(source));
    }

    private DbConnectionDataImpl create(DbSource source) {
        MetaInfo config = MetaInfo.config().with(source.getPropertyPrefix());
        Map map = config.asMap();
        config = MetaInfo.empty().with(map);
        AbstractDbDialect<?> dialect = this.getDialect(map, source);
        dialect.autoConfigure(map, source);
        DbConnectionPool<?> pool = this.createPool(config, source, (DbDialect)dialect, map);
        return new DbConnectionDataImpl(source, (DbDialect)dialect, config, pool);
    }

    private DbConnectionPool<?> createPool(MetaInfo config, DbSource source, DbDialect dialect, Map<String, String> map) {
        String poolId = config.get("pool");
        DbConnectionPoolProviderManager manager = DbConnectionPoolProviderManager.get();
        DbConnectionPoolProvider provider = null;
        if (poolId == null) {
            String url = config.getRequired("url");
            for (DbConnectionPoolProvider currentProvider : manager) {
                if (!currentProvider.isResponsible(url)) continue;
                if (provider == null) {
                    provider = currentProvider;
                    continue;
                }
                LOG.warn("Connection pool provider is ambiguous: already found {} but also found {}. Please specify property {} explicitly.", new Object[]{provider.getId(), currentProvider.getId(), source.getPropertyKey("pool")});
            }
            if (provider != null) {
                map.put("pool", provider.getId());
            }
        } else {
            provider = manager.get(poolId);
        }
        if (provider == null) {
            throw new ObjectNotFoundException((Object)"DbConnectionPoolProvider");
        }
        return provider.create(source, config, dialect);
    }

    private AbstractDbDialect<?> getDialect(Map<String, String> config, DbSource source) {
        DbDialectProvider provider = DbDialectProvider.get();
        DbDialect dialect = null;
        String dialectId = config.get("dialect");
        if (dialectId == null) {
            String url = config.get("url");
            if (url == null) {
                for (DbDialect d : provider) {
                    if (dialect != null) {
                        dialect = null;
                        break;
                    }
                    dialect = d;
                }
            } else {
                dialect = provider.getByDbUrl(url);
            }
            if (dialect == null) {
                throw new ObjectNotFoundException((Object)"Property", (Object)source.getPropertyKey("dialect"));
            }
            config.put("dialect", dialect.getId());
        } else {
            dialect = provider.get(dialectId);
        }
        return (AbstractDbDialect)dialect;
    }
}

