/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.orm.connection.impl;

import io.github.mmm.base.collection.ReadOnlyIterator;
import io.github.mmm.base.exception.DuplicateObjectException;
import io.github.mmm.base.exception.ObjectNotFoundException;
import io.github.mmm.orm.connection.DbConnection;
import io.github.mmm.orm.connection.DbConnectionPoolProvider;
import io.github.mmm.orm.connection.DbConnectionPoolProviderManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class DbConnectionPoolProviderManagerImpl
implements DbConnectionPoolProviderManager {
    public static final DbConnectionPoolProviderManagerImpl INSTANCE = new DbConnectionPoolProviderManagerImpl();
    private final Map<String, DbConnectionPoolProvider<?>> providers = new HashMap();

    public DbConnectionPoolProviderManagerImpl() {
        ServiceLoader<DbConnectionPoolProvider> loader = ServiceLoader.load(DbConnectionPoolProvider.class);
        for (DbConnectionPoolProvider provider : loader) {
            this.register(provider);
        }
    }

    private void register(DbConnectionPoolProvider<?> provider) {
        DbConnectionPoolProvider<?> duplicate = this.providers.put(provider.getId(), provider);
        if (duplicate != null) {
            throw new DuplicateObjectException(duplicate, (Object)provider.getId(), provider);
        }
    }

    @Override
    public <C extends DbConnection> DbConnectionPoolProvider<C> get(String id) {
        DbConnectionPoolProvider<?> provider = this.providers.get(id);
        if (provider == null) {
            throw new ObjectNotFoundException(DbConnectionPoolProvider.class, (Object)id);
        }
        return provider;
    }

    @Override
    public Iterator<DbConnectionPoolProvider<?>> iterator() {
        return new ReadOnlyIterator(this.providers.values().iterator());
    }
}

