/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.orm.spi.access;

import io.github.mmm.entity.bean.EntityBean;
import io.github.mmm.entity.id.Id;
import io.github.mmm.entity.id.sequence.IdSequence;
import io.github.mmm.orm.dialect.AbstractDbDialect;
import io.github.mmm.orm.dialect.DbDialectStatementFormatter;
import io.github.mmm.orm.mapping.DbMapper;
import io.github.mmm.orm.mapping.DbMapper2Java;
import io.github.mmm.orm.mapping.Orm;
import io.github.mmm.orm.metadata.DbQualifiedName;
import io.github.mmm.orm.param.AbstractCriteriaParameters;
import io.github.mmm.orm.result.DbResult;
import io.github.mmm.orm.spi.access.DbAccess;
import io.github.mmm.orm.spi.access.DbResultReceiverMultiple;
import io.github.mmm.orm.spi.access.DbResultReceiverSingle;
import io.github.mmm.orm.spi.access.impl.DbMapperRetrievalAdapter;
import io.github.mmm.orm.spi.session.DbEntitySession;
import io.github.mmm.orm.spi.session.DbSession;
import io.github.mmm.orm.statement.DbStatement;
import io.github.mmm.orm.statement.create.CreateIndexStatement;
import io.github.mmm.orm.statement.create.CreateSequenceStatement;
import io.github.mmm.orm.statement.create.CreateTableStatement;
import io.github.mmm.orm.statement.delete.DeleteClause;
import io.github.mmm.orm.statement.delete.DeleteStatement;
import io.github.mmm.orm.statement.insert.InsertStatement;
import io.github.mmm.orm.statement.merge.MergeStatement;
import io.github.mmm.orm.statement.select.SelectClause;
import io.github.mmm.orm.statement.select.SelectStatement;
import io.github.mmm.orm.statement.update.UpdateStatement;
import io.github.mmm.orm.statement.upsert.UpsertStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class AbstractDbAccess
implements DbAccess {
    protected abstract DbSession getSession();

    protected AbstractDbDialect<?> getDialect() {
        return (AbstractDbDialect)this.getSession().getConnectionData().getDialect();
    }

    protected long executeStatement(DbStatement<?> statement) {
        return this.executeStatement(statement, null, true);
    }

    protected long executeStatement(DbStatement<?> statement, Consumer<DbResult> receiver, boolean unique) {
        DbDialectStatementFormatter formatter = this.getDialect().createFormatter();
        String sql = formatter.formatStatement(statement).toString();
        AbstractCriteriaParameters parameters = (AbstractCriteriaParameters)formatter.getCriteriaFormatter().getParameters();
        if (statement.getType().isQuery()) {
            Objects.requireNonNull(receiver);
        }
        return this.executeSql(sql, parameters, receiver, unique);
    }

    protected abstract long executeSql(String var1, AbstractCriteriaParameters var2, Consumer<DbResult> var3, boolean var4);

    @Override
    public void createTable(CreateTableStatement<?> statement) {
        this.executeStatement((DbStatement<?>)statement);
    }

    @Override
    public void createIndex(CreateIndexStatement<?> statement) {
        this.executeStatement((DbStatement<?>)statement);
    }

    @Override
    public void createSequence(CreateSequenceStatement statement) {
        this.executeStatement((DbStatement<?>)statement);
    }

    @Override
    public long delete(DeleteStatement<?> statement) {
        return this.executeStatement((DbStatement<?>)statement);
    }

    @Override
    public <E extends EntityBean> boolean deleteById(Id<E> id, E prototype) {
        if (id == null || id.getPk() == null) {
            return false;
        }
        DeleteStatement statement = new DeleteClause().from(prototype).where(prototype.Id().eq(id)).get();
        long count = this.delete(statement);
        if (count > 0L) {
            assert (count == 1L);
            return true;
        }
        assert (count == 0L);
        return false;
    }

    @Override
    public <E extends EntityBean> int deleteAllById(Iterable<Id<E>> ids, E prototype) {
        Collection<Id<E>> idCollection;
        if (ids == null) {
            return 0;
        }
        if (ids instanceof Collection) {
            Collection c = (Collection)ids;
            idCollection = c;
        } else {
            idCollection = new ArrayList();
            for (Id<E> id : ids) {
                idCollection.add(id);
            }
        }
        if (idCollection.isEmpty()) {
            return 0;
        }
        DeleteStatement statement = new DeleteClause().from(prototype).where(prototype.Id().in(idCollection)).get();
        long count = this.executeStatement((DbStatement<?>)statement);
        assert (count >= 0L && count < Integer.MAX_VALUE);
        return (int)count;
    }

    @Override
    public long insert(InsertStatement<?> statement) {
        return this.executeStatement((DbStatement<?>)statement);
    }

    @Override
    public long execute(MergeStatement<?> statement) {
        return this.executeStatement((DbStatement<?>)statement);
    }

    @Override
    public long update(UpdateStatement<?> statement) {
        return this.executeStatement((DbStatement<?>)statement);
    }

    @Override
    public long execute(UpsertStatement<?> statement) {
        return this.executeStatement((DbStatement<?>)statement);
    }

    @Override
    public <R> Iterable<R> select(SelectStatement<R> statement) {
        Orm orm = this.getDialect().getOrm();
        SelectClause select = statement.getSelect();
        Object mapper = orm.createMapper(select);
        if (select.isSelectEntity()) {
            DbEntitySession<EntityBean> dbEntitySession = this.getSession().get((EntityBean)select.getResultBean());
            mapper = new DbMapperRetrievalAdapter<EntityBean>((DbMapper2Java<EntityBean>)mapper, dbEntitySession);
        }
        DbResultReceiverMultiple receiver = new DbResultReceiverMultiple(mapper);
        this.executeStatement((DbStatement<?>)statement, receiver, false);
        return receiver.getResults();
    }

    @Override
    public <R> R selectOne(SelectStatement<R> statement) {
        Orm orm = this.getDialect().getOrm();
        SelectClause select = statement.getSelect();
        DbMapper mapper = orm.createMapper(select);
        DbResultReceiverSingle receiver = new DbResultReceiverSingle(mapper);
        this.executeStatement((DbStatement<?>)statement, receiver, true);
        return receiver.getResult();
    }

    public abstract IdSequence createIdSequence(DbQualifiedName var1);
}

