/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.orm.spi.access.impl;

import io.github.mmm.base.service.ServiceHelper;
import io.github.mmm.orm.source.DbSource;
import io.github.mmm.orm.spi.access.DbAccess;
import io.github.mmm.orm.spi.access.DbAccessProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public class DbAccessProviderAdapter
implements DbAccessProvider {
    public static final DbAccessProviderAdapter INSTANCE = new DbAccessProviderAdapter();
    private final List<DbAccessProvider> providers = new ArrayList<DbAccessProvider>();
    private final Map<String, DbAccess> accesses;

    public DbAccessProviderAdapter() {
        ServiceHelper.all(ServiceLoader.load(DbAccessProvider.class), this.providers);
        this.accesses = new ConcurrentHashMap<String, DbAccess>();
    }

    @Override
    public DbAccess create(DbSource source) {
        return this.accesses.computeIfAbsent(source.getId(), k -> this.doCreate(source));
    }

    private DbAccess doCreate(DbSource source) {
        for (DbAccessProvider provider : this.providers) {
            DbAccess access = provider.create(source);
            if (access == null) continue;
            return access;
        }
        throw new IllegalStateException("Could not create DbAccess after trying " + this.providers.size() + " provider(s): " + String.valueOf(this.providers));
    }
}

