/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.orm.spi.access.impl;

import io.github.mmm.entity.bean.EntityBean;
import io.github.mmm.entity.id.Id;
import io.github.mmm.entity.id.PkId;
import io.github.mmm.orm.mapping.DbMapper2Java;
import io.github.mmm.orm.result.DbResult;
import io.github.mmm.orm.spi.session.DbEntityHolder;
import io.github.mmm.orm.spi.session.DbEntitySession;

public class DbMapperRetrievalAdapter<E extends EntityBean>
implements DbMapper2Java<E> {
    private final DbMapper2Java<E> delegate;
    private final DbEntitySession<E> entitySession;
    private int idIndex;

    public DbMapperRetrievalAdapter(DbMapper2Java<E> delegate, DbEntitySession<E> entitySession) {
        this.delegate = delegate;
        this.entitySession = entitySession;
        this.idIndex = -1;
    }

    public E db2java(DbResult dbValue) {
        if (this.idIndex == -1) {
            this.idIndex = dbValue.indexOfRequired("Id");
        }
        assert (dbValue.getName(this.idIndex).equalsIgnoreCase("Id"));
        Object pk = dbValue.getValue(this.idIndex);
        PkId id = PkId.of(this.entitySession.getEntityClass(), (Object)pk);
        DbEntityHolder<Object> holder = this.entitySession.get((Id<E>)id);
        if (holder == null) {
            EntityBean entity = (EntityBean)this.delegate.db2java(dbValue);
            holder = this.entitySession.put(entity);
        }
        return holder.getExternal();
    }
}

