/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.orm.spi.repository;

import io.github.mmm.entity.bean.EntityBean;
import io.github.mmm.entity.id.Id;
import io.github.mmm.entity.id.generator.IdGenerator;
import io.github.mmm.entity.id.generator.SequenceIdGenerator;
import io.github.mmm.entity.id.generator.UuidIdGenerator;
import io.github.mmm.orm.metadata.DbName;
import io.github.mmm.orm.metadata.DbQualifiedName;
import io.github.mmm.orm.repository.AbstractEntityRepository;
import io.github.mmm.orm.repository.DbRepository;
import io.github.mmm.orm.source.DbSource;
import io.github.mmm.orm.spi.access.AbstractDbAccess;
import io.github.mmm.orm.spi.access.DbAccess;
import io.github.mmm.orm.statement.create.CreateSequenceClause;
import io.github.mmm.orm.statement.create.CreateSequenceStatement;
import io.github.mmm.orm.statement.delete.DeleteStatement;
import io.github.mmm.orm.statement.select.SelectStatement;
import io.github.mmm.orm.statement.update.UpdateStatement;

public abstract class AbstractDbRepository<E extends EntityBean>
extends AbstractEntityRepository<E>
implements DbRepository<E> {
    public static final String DEFAULT_SEQUENCE = "ENTITY_SEQUENCE";
    private final AbstractDbAccess dbAccess = (AbstractDbAccess)DbAccess.get(this.getSource());
    private final IdGenerator idGenerator;

    public AbstractDbRepository(E prototype) {
        this(prototype, null);
    }

    public AbstractDbRepository(E prototype, IdGenerator idGenerator) {
        super(prototype);
        if (idGenerator == null) {
            DbQualifiedName sequenceName = this.getQualifiedSequenceName();
            idGenerator = sequenceName == null ? new UuidIdGenerator() : new SequenceIdGenerator(this.dbAccess.createIdSequence(sequenceName));
        }
        this.idGenerator = idGenerator;
    }

    public DbSource getSource() {
        return DbSource.get();
    }

    protected IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    protected String getSequenceName() {
        return DEFAULT_SEQUENCE;
    }

    protected DbQualifiedName getQualifiedSequenceName() {
        String sequenceName = this.getSequenceName();
        if (sequenceName == null) {
            return null;
        }
        return new DbQualifiedName(null, null, DbName.of((String)sequenceName));
    }

    public E doFindById(Id<E> id) {
        return (E)this.dbAccess.selectById(id, this.prototype);
    }

    public E findOneByQuery(SelectStatement<E> statement) {
        this.verifyEntityClass(((EntityBean)statement.getSelect().getResultBean()).getType().getClass());
        return (E)((EntityBean)this.dbAccess.selectOne(statement));
    }

    public Iterable<E> findByQuery(SelectStatement<E> statement) {
        this.verifyEntityClass(((EntityBean)statement.getSelect().getResultBean()).getJavaClass());
        return this.dbAccess.select(statement);
    }

    public long delete(DeleteStatement<E> statement) {
        return this.dbAccess.delete(statement);
    }

    protected boolean doDeleteById(Id<E> id) {
        return this.dbAccess.deleteById(id, this.prototype);
    }

    protected int doDeleteAllById(Iterable<Id<E>> ids) {
        return this.dbAccess.deleteAllById(ids, this.prototype);
    }

    protected void doInsert(E entity) {
        this.dbAccess.insert((EntityBean)entity);
    }

    protected void doUpdate(E entity) {
        this.dbAccess.update((EntityBean)entity);
    }

    public long update(UpdateStatement<E> statement) {
        return this.dbAccess.update(statement);
    }

    public void createTable() {
        this.dbAccess.createTable(this.prototype);
    }

    public void createSequence() {
        String sequenceName = this.getSequenceName();
        if (sequenceName == null) {
            return;
        }
        CreateSequenceStatement createSequenceStatement = new CreateSequenceClause(sequenceName).incrementBy(10).startWith(1000000000000L).minValue(1000000000000L).maxValue(9123456789123456789L).nocycle().get();
        this.dbAccess.createSequence(createSequenceStatement);
    }
}

