/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.orm.spi.repository;

import io.github.mmm.base.exception.ObjectNotFoundException;
import io.github.mmm.entity.bean.EntityBean;
import io.github.mmm.orm.repository.EntityRepository;
import io.github.mmm.orm.spi.repository.impl.EntityRepositoryManagerImpl;

public interface EntityRepositoryManager
extends Iterable<EntityRepository<?>> {
    public <E extends EntityBean> EntityRepository<E> getRepository(Class<E> var1);

    default public <E extends EntityBean> EntityRepository<E> getRepository(E entity) {
        Class entityClass = entity.getJavaClass();
        return this.getRepository((E)entityClass);
    }

    default public <E extends EntityBean> EntityRepository<E> getRepositoryRequired(E entity) throws ObjectNotFoundException {
        EntityRepository<E> repository = this.getRepository(entity);
        if (repository == null) {
            throw new ObjectNotFoundException((Object)EntityRepository.class.getSimpleName(), (Object)entity.getJavaClass());
        }
        return repository;
    }

    public static EntityRepositoryManager get() {
        return EntityRepositoryManagerImpl.INSTANCE;
    }
}

