/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.orm.spi.repository.impl;

import io.github.mmm.base.collection.ReadOnlyIterator;
import io.github.mmm.base.exception.ObjectNotFoundException;
import io.github.mmm.base.service.ServiceHelper;
import io.github.mmm.entity.bean.EntityBean;
import io.github.mmm.orm.connection.DbConnectionData;
import io.github.mmm.orm.repository.EntityRepository;
import io.github.mmm.orm.source.DbSource;
import io.github.mmm.orm.spi.repository.AbstractDbRepository;
import io.github.mmm.orm.spi.repository.AbstractEntityRepositoryManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class EntityRepositoryManagerImpl
extends AbstractEntityRepositoryManager {
    public static final EntityRepositoryManagerImpl INSTANCE = new EntityRepositoryManagerImpl();
    private final Map<Class<?>, EntityRepository<?>> repositoryMap = new HashMap();

    public EntityRepositoryManagerImpl() {
        ServiceLoader<EntityRepository> serviceLoader = ServiceLoader.load(EntityRepository.class);
        ServiceHelper.all(serviceLoader, this.repositoryMap, EntityRepositoryManagerImpl::getEntityClass);
    }

    private static Class<?> getEntityClass(EntityRepository<?> repository) {
        Class entityClass = repository.getEntityClass();
        if (entityClass == null) {
            throw new ObjectNotFoundException((Object)"EntityClass", repository);
        }
        if (repository instanceof AbstractDbRepository) {
            AbstractDbRepository dbRepo = (AbstractDbRepository)repository;
            DbSource source = dbRepo.getSource();
            DbConnectionData connectionData = DbConnectionData.of(source);
            connectionData.getKind();
        }
        return entityClass;
    }

    @Override
    public <E extends EntityBean> EntityRepository<E> getRepository(Class<E> entityClass) {
        return this.repositoryMap.get(entityClass);
    }

    @Override
    public Iterator<EntityRepository<?>> iterator() {
        return new ReadOnlyIterator(this.repositoryMap.values().iterator());
    }
}

