/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.orm.spi.sequence;

import io.github.mmm.entity.id.Id;
import io.github.mmm.entity.id.sequence.IdSequence;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class IdSequencePooled
implements IdSequence {
    private final Lock lock;
    private final IdSequence sequence;
    private final long increment;
    private long current;
    private long limit;

    public IdSequencePooled(IdSequence sequence, long increment) {
        Objects.requireNonNull(sequence);
        if (increment < 3L) {
            throw new IllegalArgumentException("Invalid increment '" + increment + "' - must be at least 3.");
        }
        this.lock = new ReentrantLock();
        this.sequence = sequence;
        this.increment = increment;
        this.current = 0L;
        this.limit = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long next(Id<?> template) {
        this.lock.lock();
        try {
            if (this.current == this.limit) {
                this.current = this.sequence.next(template);
                this.limit = this.current + this.increment;
            }
            assert (this.current < this.limit);
            long l = this.current++;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.current + "[" + this.limit + "]";
    }
}

