/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.orm.spi.session;

import io.github.mmm.base.exception.DuplicateObjectException;
import io.github.mmm.entity.bean.EntityBean;
import io.github.mmm.entity.id.Id;
import io.github.mmm.orm.spi.session.DbEntityHolder;
import io.github.mmm.orm.spi.session.DbEntitySession;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public abstract class AbstractDbEntitySession<E extends EntityBean>
implements DbEntitySession<E> {
    protected final Class<E> entityClass;
    private final Map<Object, DbEntityHolder<E>> entityMap;

    public AbstractDbEntitySession(Class<E> entityClass) {
        this.entityClass = entityClass;
        this.entityMap = new HashMap<Object, DbEntityHolder<E>>();
    }

    @Override
    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public DbEntityHolder<E> getOrLoad(Id<E> id, Function<Id<E>, E> loader) {
        if (id == null) {
            return null;
        }
        Object pk = id.getPk();
        if (pk == null) {
            return null;
        }
        DbEntityHolder holder = loader == null ? this.entityMap.get(pk) : this.entityMap.computeIfAbsent(pk, k -> this.createHolder((EntityBean)loader.apply(id)));
        return holder;
    }

    @Override
    public DbEntityHolder<E> put(E managedEntity, Id<E> id) {
        Objects.requireNonNull(managedEntity);
        Objects.requireNonNull(id);
        Object pk = id.getPk();
        if (pk == null) {
            throw new IllegalArgumentException("Missing primary key for given ID " + String.valueOf(id));
        }
        DbEntityHolder<E> holder = this.createHolder(managedEntity);
        DbEntityHolder<E> duplicate = this.entityMap.putIfAbsent(pk, holder);
        if (duplicate != null) {
            throw new DuplicateObjectException(managedEntity, id, duplicate);
        }
        return holder;
    }

    protected abstract DbEntityHolder<E> createHolder(E var1);

    protected void close() {
        this.entityMap.clear();
    }
}

