/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.orm.spi.session;

import io.github.mmm.entity.bean.EntityBean;
import io.github.mmm.orm.connection.DbConnectionData;
import io.github.mmm.orm.spi.session.DbEntitySession;
import io.github.mmm.orm.spi.session.DbSession;
import io.github.mmm.orm.spi.session.impl.DbEntitySessionDefault;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractDbSession
implements DbSession {
    private Map<String, DbEntitySession<?>> entitySessions;
    protected final DbConnectionData connectionData;

    protected AbstractDbSession(DbConnectionData connectionData) {
        this.connectionData = connectionData;
        this.entitySessions = new HashMap();
    }

    @Override
    public <E extends EntityBean> DbEntitySession<E> get(E entity) {
        String key = entity.getType().getQualifiedName();
        DbEntitySession session = this.entitySessions.computeIfAbsent(key, k -> this.newEntitySession(entity));
        return session;
    }

    private <E extends EntityBean> DbEntitySession<E> newEntitySession(E entity) {
        return new DbEntitySessionDefault<E>(entity);
    }

    @Override
    public DbConnectionData getConnectionData() {
        return this.connectionData;
    }
}

