/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.orm.sync;

import io.github.mmm.bean.BeanFactory;
import io.github.mmm.entity.bean.EntityBean;
import io.github.mmm.orm.connection.DbConnection;
import io.github.mmm.orm.dialect.DbDialect;
import io.github.mmm.orm.metadata.DbMetaData;
import io.github.mmm.orm.metadata.DbName;
import io.github.mmm.orm.metadata.DbQualifiedName;
import io.github.mmm.orm.metadata.DbTable;
import io.github.mmm.orm.repository.EntityRepository;
import io.github.mmm.orm.source.DbSource;
import io.github.mmm.orm.spi.access.DbAccess;
import io.github.mmm.orm.spi.repository.AbstractDbRepository;
import io.github.mmm.orm.spi.repository.EntityRepositoryManager;
import io.github.mmm.orm.sync.ModelSynchronizer;
import io.github.mmm.property.WritableProperty;

public class ModelSynchronizerImpl
implements ModelSynchronizer {
    private DbConnection connection;
    private DbDialect dialect;
    private DbAccess dbAccess;

    @Override
    public void sync() {
        EntityRepositoryManager erm = EntityRepositoryManager.get();
        for (EntityRepository repository : erm) {
            if (!(repository instanceof AbstractDbRepository)) continue;
            AbstractDbRepository aer = (AbstractDbRepository)repository;
            DbSource source = aer.getSource();
            EntityBean entity = aer.getPrototype();
            this.sync(entity);
        }
    }

    @Override
    public void sync(Class<? extends EntityBean> entityClass) {
        BeanFactory factory = BeanFactory.get();
        EntityBean entity = (EntityBean)factory.create(entityClass);
        this.sync(entity);
    }

    @Override
    public void sync(EntityBean entity) {
        DbName tableName;
        DbName schema;
        DbName catalog;
        DbQualifiedName qName;
        DbMetaData metaData = this.connection.getMetaData();
        DbTable table = metaData.getTable(qName = new DbQualifiedName(catalog = metaData.getCurrentCatalog(), schema = metaData.getCurrentSchema(), tableName = DbName.of((String)this.dialect.getNamingStrategy().getTableName(entity))));
        if (table == null) {
            this.dbAccess.createTable(entity);
            return;
        }
        for (WritableProperty property : entity.getProperties()) {
            if (property.isTransient()) continue;
            String string = property.getName();
        }
    }
}

