/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.builder;

import io.github.mmm.base.metainfo.MetaInfo;
import io.github.mmm.property.AttributeReadOnly;
import io.github.mmm.property.Property;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.builder.container.ListPropertyBuilder;
import io.github.mmm.property.builder.container.MapPropertyBuilder;
import io.github.mmm.property.builder.container.SetPropertyBuilder;
import io.github.mmm.property.object.SimpleProperty;
import io.github.mmm.validation.Validator;
import io.github.mmm.validation.main.ObjectValidatorBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class PropertyBuilder<V, P extends Property<V>, B extends ObjectValidatorBuilder<V, ? extends PropertyBuilder<V, P, B, SELF>, ?>, SELF extends PropertyBuilder<V, P, B, SELF>> {
    protected final AttributeReadOnly lock;
    private Consumer<? super P> registry;
    private Function<String, P> factory;
    private B validatorBuilder;
    protected Supplier<? extends V> expression;
    protected V value;
    private Map<String, String> metadataMap;

    public PropertyBuilder(AttributeReadOnly lock) {
        this.lock = lock;
    }

    protected SELF self() {
        return (SELF)this;
    }

    public AttributeReadOnly getLock() {
        return this.lock;
    }

    public SELF registry(Consumer<? super P> consumer) {
        if (this.registry != null) {
            throw new IllegalStateException("Registry consumer already set!");
        }
        this.registry = consumer;
        return this.self();
    }

    public SELF factory(Function<String, P> function) {
        if (this.factory != null) {
            throw new IllegalStateException("Factory function already set!");
        }
        this.factory = function;
        return this.self();
    }

    public SELF valueExpression(Supplier<? extends V> propertyValueExpression) {
        this.expression = propertyValueExpression;
        return this.self();
    }

    public SELF value(V initialValue) {
        this.value = initialValue;
        return this.self();
    }

    public SELF metaInfo(String metaKey, String metaValue) {
        if (this.metadataMap == null) {
            this.metadataMap = new HashMap<String, String>();
        }
        this.metadataMap.put(metaKey, metaValue);
        return this.self();
    }

    protected abstract B createValidatorBuilder();

    public B withValidator() {
        if (this.validatorBuilder == null) {
            this.validatorBuilder = this.createValidatorBuilder();
        }
        return this.validatorBuilder;
    }

    public final P build(String name) {
        return this.build(name, false);
    }

    protected final P build(String name, boolean ignoreExtensions) {
        Object property = null;
        if (this.factory != null && !ignoreExtensions) {
            property = (Property)this.factory.apply(name);
        }
        if (property == null) {
            property = this.build(name, this.newMetadata());
            if (this.value != null) {
                property.set(this.value);
            }
        }
        if (this.registry != null && !ignoreExtensions) {
            this.registry.accept(property);
        }
        return (P)property;
    }

    private PropertyMetadata<V> newMetadata() {
        Validator validator = null;
        if (this.validatorBuilder != null) {
            validator = this.validatorBuilder.build();
        }
        return PropertyMetadata.of((AttributeReadOnly)this.lock, (Validator)validator, null, (MetaInfo)MetaInfo.empty().with(this.metadataMap));
    }

    protected abstract P build(String var1, PropertyMetadata<V> var2);

    public ListPropertyBuilder<V> asList() {
        return this.builder(new ListPropertyBuilder(this.lock, this.build("ListItem", true)));
    }

    public SetPropertyBuilder<V> asSet() {
        return this.builder(new SetPropertyBuilder(this.lock, this.build("SetItem", true)));
    }

    public MapPropertyBuilder<String, V> asMap() {
        return this.builder(new MapPropertyBuilder(this.lock, this.build("MapItem", true)));
    }

    protected <T extends PropertyBuilder<?, ?, ?, ?>> T builder(T builder) {
        if (this.registry != null) {
            builder.registry(this.registry);
        }
        if (this.factory != null) {
            builder.factory(this.factory);
        }
        return builder;
    }

    public <K> MapPropertyBuilder<K, V> asMap(SimpleProperty<K> keyProperty) {
        return new MapPropertyBuilder(this.lock, keyProperty, this.build("Value"));
    }
}

