/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.builder;

import io.github.mmm.property.AttributeReadOnly;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.builder.PropertyBuilder;
import io.github.mmm.property.builder.PropertyBuilders;
import java.util.function.Consumer;
import java.util.function.Function;

public final class PropertyBuildersHelper {
    private PropertyBuildersHelper() {
    }

    public static <T> T get(Object input, PropertyBuilders registry, Function<PropertyMetadata, T> factory) {
        T result = null;
        if (registry instanceof Function) {
            result = (T)((Function)((Object)registry)).apply(input);
        }
        if (result == null) {
            PropertyMetadata metadata = PropertyMetadata.of((AttributeReadOnly)registry.getLock());
            result = factory.apply(metadata);
        }
        return result;
    }

    public static <T> T accept(T object, Object consumer) {
        if (consumer instanceof Consumer) {
            ((Consumer)consumer).accept(object);
        }
        return object;
    }

    public static <B extends PropertyBuilder<?, ?, ?, ?>> B builder(B builder, Object registry) {
        if (registry instanceof Consumer) {
            builder.registry((Consumer)registry);
        }
        if (registry instanceof Function) {
            builder.factory((Function)registry);
        }
        return builder;
    }
}

