/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.builder.container;

import io.github.mmm.property.AttributeReadOnly;
import io.github.mmm.property.Property;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.builder.PropertyBuilder;
import io.github.mmm.property.container.map.MapProperty;
import io.github.mmm.property.object.SimpleProperty;
import io.github.mmm.validation.collection.ValidatorBuilderMap;
import java.util.Map;

public class MapPropertyBuilder<K, V>
extends PropertyBuilder<Map<K, V>, MapProperty<K, V>, ValidatorBuilderMap<K, V, MapPropertyBuilder<K, V>>, MapPropertyBuilder<K, V>> {
    private SimpleProperty<K> keyProperty;
    private Property<V> valueProperty;

    public MapPropertyBuilder(AttributeReadOnly lock) {
        this(lock, null, null);
    }

    public MapPropertyBuilder(AttributeReadOnly lock, Property<V> valueProperty) {
        this(lock, null, valueProperty);
    }

    public MapPropertyBuilder(AttributeReadOnly lock, SimpleProperty<K> keyProperty, Property<V> valueProperty) {
        super(lock);
        this.keyProperty = keyProperty;
        this.valueProperty = valueProperty;
    }

    public MapPropertyBuilder<K, V> keyProperty(SimpleProperty<K> property) {
        this.keyProperty = property;
        return this;
    }

    public MapPropertyBuilder<K, V> valueProperty(Property<V> property) {
        this.valueProperty = property;
        return this;
    }

    @Override
    protected ValidatorBuilderMap<K, V, MapPropertyBuilder<K, V>> createValidatorBuilder() {
        return new ValidatorBuilderMap((Object)this);
    }

    @Override
    protected MapProperty<K, V> build(String name, PropertyMetadata<Map<K, V>> metadata) {
        return new MapProperty(name, this.keyProperty, this.valueProperty, metadata);
    }
}

