/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property;

import io.github.mmm.base.exception.ReadOnlyException;
import io.github.mmm.base.text.CaseHelper;
import io.github.mmm.marshall.Marshalling;
import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.StructuredWriter;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.ReadableProperty;
import io.github.mmm.property.WritableProperty;
import io.github.mmm.property.impl.metadata.PropertyMetadataNone;
import io.github.mmm.validation.Validatable;
import io.github.mmm.validation.ValidationResult;
import io.github.mmm.value.observable.AbstractWritableObservableValue;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class Property<V>
extends AbstractWritableObservableValue<V>
implements WritableProperty<V>,
Cloneable {
    private String name;
    private PropertyMetadata<V> metadata;
    private ValidationResult validationResult;
    private Property<V> readOnlyProperty;

    public Property(String name) {
        this(name, null);
    }

    public Property(String name, PropertyMetadata<V> metadata) {
        this.name = name;
        this.metadata = metadata == null ? PropertyMetadataNone.get() : metadata;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PropertyMetadata<V> getMetadata() {
        return this.metadata;
    }

    @Override
    public int compareTo(ReadableProperty<?> otherProperty) {
        if (otherProperty == null) {
            return 1;
        }
        return this.name.compareTo(otherProperty.getName());
    }

    protected final Property<V> clone() {
        try {
            return (Property)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public final Property<V> copy(String newName, PropertyMetadata<V> newMetadata) {
        Object copy = this.clone();
        copy.bindInternal(null);
        ((Property)copy).readOnlyProperty = null;
        ((Property)copy).validationResult = null;
        if (newName != null) {
            ((Property)copy).name = newName;
        }
        if (newMetadata != null) {
            ((Property)copy).metadata = newMetadata;
        }
        return copy;
    }

    public V get() {
        Supplier<V> expression = this.metadata.getExpression();
        if (expression != null) {
            return expression.get();
        }
        return (V)super.get();
    }

    protected void setWithChange(V oldValue, V value) {
        super.setWithChange(oldValue, value);
        this.clearValidationResult();
    }

    protected final void requireWritable() throws IllegalStateException {
        if (this.isReadOnly()) {
            throw new ReadOnlyException((Object)("Property " + this.getName() + " is readonly and cannot be modified."));
        }
    }

    @Override
    public boolean isValid() {
        if (this.validationResult == null) {
            this.validate();
        }
        return this.validationResult.isValid();
    }

    protected void clearValidationResult() {
        this.validationResult = null;
    }

    public final ValidationResult validate() {
        if (this.validationResult == null || this.isValueMutable()) {
            this.validationResult = this.doValidate(this.get(), this.getName());
        }
        return this.validationResult;
    }

    public ValidationResult doValidate(String source) {
        return this.doValidate(this.get(), source);
    }

    protected ValidationResult doValidate(V v, String source) {
        ValidationResult result = this.metadata.getValidator().validate(v, (Object)source);
        if (v instanceof Validatable) {
            result = result.add(((Validatable)v).validate());
        }
        return result;
    }

    public boolean isValueMutable() {
        return false;
    }

    @Override
    public WritableProperty<V> getReadOnly() {
        if (this.readOnlyProperty == null) {
            if (this.metadata.getExpression() != null) {
                this.readOnlyProperty = this;
            } else {
                WritableProperty copy = this.copy((String)null, (PropertyMetadata)this.metadata.withLock(null).withExpression(this.createReadOnlyExpression()));
                ((Property)copy).makeReadOnly();
                this.readOnlyProperty = copy;
            }
        }
        return this.readOnlyProperty;
    }

    protected Supplier<? extends V> createReadOnlyExpression() {
        return this::get;
    }

    protected void makeReadOnly() {
        super.makeReadOnly();
        this.readOnlyProperty = this;
    }

    @Override
    public final boolean isReadOnly() {
        if (this.readOnlyProperty == this) {
            return true;
        }
        if (this.metadata.getExpression() != null) {
            return true;
        }
        if (this.isBoundOneWay()) {
            return true;
        }
        return this.metadata.getLock().isReadOnly();
    }

    protected boolean isSensitive() {
        String nameLowerCase = CaseHelper.toLowerCase((String)this.name);
        return nameLowerCase.endsWith("password") || nameLowerCase.endsWith("credential") || nameLowerCase.endsWith("secret") || nameLowerCase.endsWith("passphrase") || nameLowerCase.equals("pin");
    }

    public final void writeObject(StructuredWriter writer, Object object) {
        if (object != this) {
            throw new IllegalStateException();
        }
        Marshalling<V> marshalling = this.metadata.getMarshalling();
        if (marshalling == null) {
            this.write(writer);
        } else {
            marshalling.writeObject(writer, this.get());
        }
    }

    public final void write(StructuredWriter writer) {
        this.writeValue(writer, this.get());
    }

    public void writeValue(StructuredWriter writer, V value) {
        writer.writeValue(value);
    }

    public final Property<V> readObject(StructuredReader reader) {
        Marshalling<V> marshalling = this.metadata.getMarshalling();
        if (marshalling == null) {
            this.readValue(reader, true);
        } else {
            Object value = marshalling.readObject(reader);
            this.set(value);
        }
        return this;
    }

    public final Property<V> read(StructuredReader reader) {
        this.readValue(reader, true);
        return this;
    }

    public final V readValue(StructuredReader reader) {
        return this.readValue(reader, false);
    }

    protected V readValue(StructuredReader reader, boolean apply) {
        Object value = reader.readValue(this.getValueClass());
        if (apply) {
            this.set(value);
        }
        return (V)value;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
        sb.append('=');
        if (this.isSensitive()) {
            sb.append("**********");
        } else {
            sb.append(this.get());
        }
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.get(), other.get());
    }
}

