/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property;

import io.github.mmm.base.metainfo.MetaInfo;
import io.github.mmm.marshall.Marshalling;
import io.github.mmm.property.AttributeReadOnly;
import io.github.mmm.property.impl.metadata.PropertyMetadataExpression;
import io.github.mmm.property.impl.metadata.PropertyMetadataInfo;
import io.github.mmm.property.impl.metadata.PropertyMetadataLock;
import io.github.mmm.property.impl.metadata.PropertyMetadataNone;
import io.github.mmm.property.impl.metadata.PropertyMetadataValidator;
import io.github.mmm.property.impl.readonly.AttributeNeverReadOnly;
import io.github.mmm.validation.Validator;
import java.util.function.Supplier;

public interface PropertyMetadata<V> {
    public static final String KEY_TRANSIENT = "transient";

    public Validator<? super V> getValidator();

    public Supplier<? extends V> getExpression();

    default public Marshalling<V> getMarshalling() {
        return null;
    }

    default public MetaInfo getMetaInfo() {
        return MetaInfo.empty();
    }

    default public boolean isTransient() {
        return this.getExpression() != null || this.getMetaInfo().getAsBoolean(KEY_TRANSIENT, false);
    }

    public PropertyMetadata<V> withLock(AttributeReadOnly var1);

    public PropertyMetadata<V> withValidator(Validator<? super V> var1);

    public PropertyMetadata<V> withExpression(Supplier<? extends V> var1);

    public PropertyMetadata<V> withMetaInfo(MetaInfo var1);

    default public AttributeReadOnly getLock() {
        return AttributeNeverReadOnly.INSTANCE;
    }

    public static <V> PropertyMetadata<V> of(AttributeReadOnly lock, Validator<? super V> validator, Supplier<? extends V> expression, MetaInfo metaInfo) {
        if (PropertyMetadata.isNotEmpty(metaInfo)) {
            return new PropertyMetadataInfo<V>(lock, validator, expression, metaInfo);
        }
        if (expression != null) {
            return new PropertyMetadataExpression<V>(lock, validator, expression);
        }
        if (Validator.isValidating(validator)) {
            return new PropertyMetadataValidator<V>(lock, validator);
        }
        if (lock != null) {
            return new PropertyMetadataLock(lock);
        }
        return PropertyMetadataNone.get();
    }

    private static boolean isNotEmpty(MetaInfo metaInfo) {
        if (metaInfo == null) {
            return false;
        }
        return !metaInfo.isEmpty();
    }

    public static <V> PropertyMetadata<V> of(AttributeReadOnly lock) {
        return PropertyMetadata.of(lock, null, null, null);
    }

    public static <V> PropertyMetadata<V> of(AttributeReadOnly lock, Validator<? super V> validator) {
        return PropertyMetadata.of(lock, validator, null, null);
    }

    public static <V> PropertyMetadata<V> of(AttributeReadOnly lock, Validator<? super V> validator, Supplier<? extends V> expression) {
        return PropertyMetadata.of(lock, validator, expression, null);
    }

    public static <V> PropertyMetadata<V> ofExpression(Supplier<? extends V> expression) {
        return PropertyMetadata.of(null, null, expression, null);
    }
}

