/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property;

import io.github.mmm.marshall.MarshallableObject;
import io.github.mmm.property.AttributeReadOnly;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.criteria.CriteriaAggregation;
import io.github.mmm.property.criteria.CriteriaPredicate;
import io.github.mmm.property.criteria.PredicateOperator;
import io.github.mmm.validation.Validatable;
import io.github.mmm.value.PropertyPath;
import io.github.mmm.value.ReadablePath;
import io.github.mmm.value.converter.TypeMapper;
import io.github.mmm.value.observable.ObservableValue;

public interface ReadableProperty<V>
extends ObservableValue<V>,
PropertyPath<V>,
MarshallableObject,
Validatable,
AttributeReadOnly,
Comparable<ReadableProperty<?>> {
    public String getName();

    default public String getQualifiedName() {
        return this.getQualifiedName(true);
    }

    default public String getQualifiedName(boolean fixed) {
        String path = "";
        AttributeReadOnly lock = this.getMetadata().getLock();
        if (lock instanceof ReadablePath) {
            path = ((ReadablePath)lock).path(fixed);
        }
        if (path.isEmpty()) {
            return this.getName();
        }
        return path + "." + this.getName();
    }

    default public ReadablePath parentPath() {
        AttributeReadOnly lock = this.getMetadata().getLock();
        if (lock instanceof ReadablePath) {
            return (ReadablePath)lock;
        }
        return super.parentPath();
    }

    public boolean isValid();

    default public TypeMapper<V, ?> getTypeMapper() {
        return null;
    }

    default public boolean isTransient() {
        return this.getMetadata().isTransient();
    }

    default public boolean isMandatory() {
        return this.getMetadata().getValidator().isMandatory();
    }

    public PropertyMetadata<V> getMetadata();

    default public CriteriaPredicate eq(V other) {
        return CriteriaPredicate.of(this, PredicateOperator.EQ, other);
    }

    default public CriteriaPredicate eq(PropertyPath<V> other) {
        return CriteriaPredicate.of(this, PredicateOperator.EQ, other);
    }

    default public CriteriaPredicate neq(V other) {
        return CriteriaPredicate.of(this, PredicateOperator.NEQ, other);
    }

    default public CriteriaPredicate neq(PropertyPath<V> other) {
        return CriteriaPredicate.of(this, PredicateOperator.NEQ, other);
    }

    default public CriteriaAggregation<Integer> count() {
        return CriteriaAggregation.count(this);
    }

    default public boolean isEqual(ReadableProperty<?> other) {
        return this.equals(other);
    }
}

