/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.container;

import io.github.mmm.property.Property;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.WritableProperty;
import io.github.mmm.property.booleans.BooleanProperty;
import io.github.mmm.property.booleans.ReadableBooleanProperty;
import io.github.mmm.property.container.WritableContainerProperty;
import io.github.mmm.property.impl.metadata.PropertyMetadataExpression;
import io.github.mmm.property.impl.metadata.PropertyMetadataNone;
import io.github.mmm.property.number.integers.IntegerProperty;
import io.github.mmm.property.number.integers.ReadableIntegerProperty;
import io.github.mmm.value.observable.AbstractObservableValue;
import java.util.function.Supplier;

public abstract class ContainerProperty<V, E>
extends Property<V>
implements WritableContainerProperty<V, E> {
    protected final Property<E> valueProperty;
    private IntegerProperty sizeProperty;
    private BooleanProperty emptyProperty;

    public ContainerProperty(String name, WritableProperty<E> valueProperty) {
        this(name, valueProperty, PropertyMetadataNone.get());
    }

    public ContainerProperty(String name, WritableProperty<E> valueProperty, PropertyMetadata<V> metadata) {
        super(name, metadata);
        this.valueProperty = (Property)valueProperty;
    }

    @Override
    public boolean isValueMutable() {
        return true;
    }

    protected boolean isValueEqual(V newValue, V oldValue) {
        return newValue == oldValue;
    }

    @Override
    public WritableProperty<E> getValueProperty() {
        return this.valueProperty;
    }

    @Override
    public ReadableIntegerProperty sizeProperty() {
        if (this.sizeProperty == null) {
            this.getChangeAwareValue();
            this.sizeProperty = new IntegerProperty(this.getName() + ".size", (PropertyMetadata<Integer>)new PropertyMetadataExpression<Integer>(() -> this.size()));
        }
        return this.sizeProperty;
    }

    @Override
    public ReadableBooleanProperty emptyProperty() {
        if (this.emptyProperty == null) {
            this.getChangeAwareValue();
            this.emptyProperty = new BooleanProperty(this.getName() + ".empty", (PropertyMetadata<Boolean>)new PropertyMetadataExpression<Boolean>(() -> this.isEmpty()));
        }
        return this.emptyProperty;
    }

    protected void invalidateProperties() {
        this.fireEventFor((AbstractObservableValue)this.sizeProperty);
        this.fireEventFor((AbstractObservableValue)this.emptyProperty);
    }

    @Override
    protected abstract Supplier<? extends V> createReadOnlyExpression();
}

