/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.container.collection;

import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.StructuredWriter;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.WritableProperty;
import io.github.mmm.property.container.ContainerProperty;
import io.github.mmm.property.container.collection.WritableCollectionProperty;
import io.github.mmm.validation.ValidationResult;
import io.github.mmm.validation.ValidationResultBuilder;
import java.util.Collection;

public abstract class CollectionProperty<V extends Collection<E>, E>
extends ContainerProperty<V, E>
implements WritableCollectionProperty<V, E> {
    public CollectionProperty(String name, WritableProperty<E> valueProperty) {
        super(name, valueProperty);
    }

    public CollectionProperty(String name, WritableProperty<E> valueProperty, PropertyMetadata<V> metadata) {
        super(name, valueProperty, metadata);
    }

    @Override
    protected ValidationResult doValidate(V collection, String source) {
        ValidationResult result = super.doValidate(collection, source);
        if (this.valueProperty != null && collection != null && !collection.isEmpty()) {
            ValidationResultBuilder builder = new ValidationResultBuilder(false);
            builder.add(result);
            int index = 0;
            for (Object element : collection) {
                this.valueProperty.set(element);
                builder.add(this.valueProperty.doValidate("#" + index));
                ++index;
            }
            result = builder.build(source);
        }
        return result;
    }

    @Override
    protected V readValue(StructuredReader reader, boolean apply) {
        Collection collection = null;
        if (!apply) {
            collection = (Collection)this.create();
        }
        if (!reader.readStartArray()) {
            if (apply && (collection = (Collection)this.getValue()) != null) {
                collection.clear();
            }
        } else {
            if (apply) {
                collection = (Collection)this.getOrCreate();
            }
            do {
                Object element;
                if (this.valueProperty == null) {
                    element = reader.readValue();
                } else {
                    this.valueProperty.read(reader);
                    element = this.valueProperty.get();
                }
                collection.add(element);
            } while (!reader.readEnd());
        }
        return (V)collection;
    }

    @Override
    public void writeValue(StructuredWriter writer, V collection) {
        if (collection == null) {
            writer.writeValueAsNull();
            return;
        }
        writer.writeStartArray();
        for (Object element : collection) {
            if (this.valueProperty == null) {
                writer.writeValue(element);
                continue;
            }
            this.valueProperty.set(element);
            this.valueProperty.write(writer);
        }
        writer.writeEnd();
    }
}

