/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.container.list;

import io.github.mmm.event.EventListener;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.WritableProperty;
import io.github.mmm.property.container.collection.CollectionProperty;
import io.github.mmm.property.container.list.WritableListProperty;
import io.github.mmm.value.observable.container.list.ChangeAwareList;
import io.github.mmm.value.observable.container.list.ChangeAwareLists;
import io.github.mmm.value.observable.container.list.ListChangeListener;
import java.util.List;
import java.util.function.Supplier;

public class ListProperty<E>
extends CollectionProperty<List<E>, E>
implements WritableListProperty<E> {
    private List<E> value;
    private ChangeAwareList<E> changeAwareList;

    public ListProperty(String name, WritableProperty<E> valueProperty) {
        super(name, valueProperty);
    }

    public ListProperty(String name, WritableProperty<E> valueProperty, PropertyMetadata<List<E>> metadata) {
        super(name, valueProperty, metadata);
    }

    protected List<E> doGet() {
        if (this.changeAwareList != null) {
            return this.changeAwareList;
        }
        return this.value;
    }

    protected void doSet(List<E> newValue) {
        if (this.changeAwareList != null) {
            if (newValue == null) {
                this.changeAwareList.clear();
            } else {
                this.changeAwareList.setAll(newValue);
            }
        } else {
            this.value = newValue;
        }
    }

    @Override
    public boolean isChangeAware() {
        return this.changeAwareList != null;
    }

    @Override
    public ChangeAwareList<E> getChangeAwareValue() {
        if (this.changeAwareList == null) {
            this.changeAwareList = ChangeAwareLists.of(this.value);
            this.changeAwareList.addListener((EventListener)((ListChangeListener)change -> {
                this.invalidateProperties();
                this.fireChange(change);
            }));
        }
        return this.changeAwareList;
    }

    @Override
    protected Supplier<? extends List<E>> createReadOnlyExpression() {
        if (this.changeAwareList == null) {
            ChangeAwareList readOnlyList = ChangeAwareLists.ofUnmodifiable(() -> ((ListProperty)this).getSafe());
            return () -> this.lambda$createReadOnlyExpression$1((List)readOnlyList);
        }
        ChangeAwareList readOnlyList = ChangeAwareLists.ofUnmodifiable(this.changeAwareList);
        return () -> ListProperty.lambda$createReadOnlyExpression$2((List)readOnlyList);
    }

    private static /* synthetic */ List lambda$createReadOnlyExpression$2(List readOnlyList) {
        return readOnlyList;
    }

    private /* synthetic */ List lambda$createReadOnlyExpression$1(List readOnlyList) {
        List result = (List)this.get();
        if (result == null) {
            return null;
        }
        return readOnlyList;
    }
}

