/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.container.map;

import io.github.mmm.event.EventListener;
import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.StructuredWriter;
import io.github.mmm.marshall.id.StructuredIdMapping;
import io.github.mmm.marshall.id.StructuredIdMappingObject;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.WritableProperty;
import io.github.mmm.property.container.ContainerProperty;
import io.github.mmm.property.container.map.WritableMapProperty;
import io.github.mmm.property.impl.metadata.PropertyMetadataNone;
import io.github.mmm.property.object.SimpleProperty;
import io.github.mmm.property.object.WritableSimpleProperty;
import io.github.mmm.validation.ValidationResult;
import io.github.mmm.validation.ValidationResultBuilder;
import io.github.mmm.value.observable.container.map.ChangeAwareMap;
import io.github.mmm.value.observable.container.map.ChangeAwareMaps;
import io.github.mmm.value.observable.container.map.MapChangeListener;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class MapProperty<K, V>
extends ContainerProperty<Map<K, V>, V>
implements WritableMapProperty<K, V>,
StructuredIdMappingObject {
    private static final String NAME_KEY = "key";
    private static final String NAME_VALUE = "value";
    protected final SimpleProperty<K> keyProperty;
    private Map<K, V> value;
    private ChangeAwareMap<K, V> changeAwareMap;

    public MapProperty(String name, WritableSimpleProperty<K> keyProperty, WritableProperty<V> valueProperty) {
        this(name, keyProperty, valueProperty, PropertyMetadataNone.get());
    }

    public MapProperty(String name, WritableSimpleProperty<K> keyProperty, WritableProperty<V> valueProperty, PropertyMetadata<Map<K, V>> metadata) {
        super(name, valueProperty, metadata);
        this.keyProperty = (SimpleProperty)keyProperty;
    }

    @Override
    public WritableSimpleProperty<K> getKeyProperty() {
        return this.keyProperty;
    }

    protected Map<K, V> doGet() {
        if (this.changeAwareMap != null) {
            return this.changeAwareMap;
        }
        return this.value;
    }

    protected void doSet(Map<K, V> newValue) {
        if (this.changeAwareMap != null) {
            if (newValue == null) {
                this.changeAwareMap.clear();
            } else {
                this.changeAwareMap.putAll(newValue);
            }
        } else {
            this.value = newValue;
        }
    }

    @Override
    protected ValidationResult doValidate(Map<K, V> map, String source) {
        ValidationResult result = super.doValidate(map, source);
        if (!(this.valueProperty == null && this.keyProperty == null || map == null || map.isEmpty())) {
            ValidationResultBuilder builder = new ValidationResultBuilder(false);
            builder.add(result);
            int index = 0;
            for (Map.Entry<K, V> entry : map.entrySet()) {
                String indexSource = "#" + index;
                if (this.valueProperty != null) {
                    this.valueProperty.set(entry.getValue());
                    builder.add(this.valueProperty.doValidate(indexSource));
                }
                if (this.keyProperty != null) {
                    this.keyProperty.set(entry.getKey());
                    builder.add(this.keyProperty.doValidate(indexSource));
                }
                ++index;
            }
            result = builder.build(source);
        }
        return result;
    }

    @Override
    public boolean isChangeAware() {
        return this.changeAwareMap != null;
    }

    @Override
    public ChangeAwareMap<K, V> getChangeAwareValue() {
        if (this.changeAwareMap == null) {
            this.changeAwareMap = ChangeAwareMaps.of(this.value);
            this.changeAwareMap.addListener((EventListener)((MapChangeListener)change -> {
                this.invalidateProperties();
                this.fireChange(change);
            }));
        }
        return this.changeAwareMap;
    }

    @Override
    protected Map<K, V> readValue(StructuredReader reader, boolean apply) {
        boolean empty;
        Map map = null;
        if (!apply) {
            map = this.create();
        }
        if (reader.getFormat().isIdBased()) {
            empty = !reader.readStartArray();
        } else {
            boolean bl = empty = !reader.readStartObject((StructuredIdMappingObject)this);
        }
        if (empty) {
            if (apply && (map = (Map)this.getValue()) != null) {
                map.clear();
            }
        } else {
            if (apply) {
                map = (Map)this.getOrCreate();
            }
            do {
                K mapKey = this.readMapKey(reader);
                V mapValue = this.readMapValue(reader);
                map.put(mapKey, mapValue);
            } while (!reader.readEnd());
        }
        return map;
    }

    private K readMapKey(StructuredReader reader) {
        if (reader.getFormat().isIdBased()) {
            if (reader.isName(NAME_KEY)) {
                K key = this.readMapKey(reader, false);
                if (reader.isName(NAME_VALUE)) {
                    return key;
                }
            }
            throw new IllegalStateException("Invalid map entry - unexpected property " + reader.getName());
        }
        return this.readMapKey(reader, true);
    }

    protected K readMapKey(StructuredReader reader, boolean asName) {
        if (this.keyProperty == null) {
            if (asName) {
                return (K)reader.readName();
            }
            return (K)reader.readValue();
        }
        this.keyProperty.read(reader);
        return (K)this.keyProperty.get();
    }

    protected V readMapValue(StructuredReader reader) {
        if (this.valueProperty == null) {
            return (V)reader.readValue();
        }
        this.valueProperty.read(reader);
        return this.valueProperty.get();
    }

    @Override
    public void writeValue(StructuredWriter writer, Map<K, V> map) {
        if (map == null) {
            writer.writeValueAsNull();
            return;
        }
        if (writer.getFormat().isIdBased()) {
            writer.writeStartArray();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                writer.writeName(NAME_KEY);
                this.writeMapKey(writer, entry.getKey(), false);
                writer.writeName(NAME_VALUE);
                this.writeMapValue(writer, entry.getValue());
            }
        } else {
            writer.writeStartObject((StructuredIdMappingObject)this);
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.writeMapKey(writer, entry.getKey(), true);
                this.writeMapValue(writer, entry.getValue());
            }
        }
        writer.writeEnd();
    }

    protected void writeMapKey(StructuredWriter writer, K key, boolean asName) {
        String string;
        if (this.keyProperty == null) {
            string = Objects.toString(key);
        } else {
            this.keyProperty.set(key);
            string = this.keyProperty.getAsString();
        }
        if (asName) {
            writer.writeName(string);
        } else {
            writer.writeValueAsString(string);
        }
    }

    protected void writeMapValue(StructuredWriter writer, V mapValue) {
        if (this.valueProperty == null) {
            writer.writeValue(mapValue);
        } else {
            this.valueProperty.set(mapValue);
            this.valueProperty.write(writer);
        }
    }

    public StructuredIdMapping defineIdMapping() {
        return StructuredIdMapping.of((String[])new String[]{NAME_KEY, NAME_VALUE});
    }

    @Override
    protected Supplier<? extends Map<K, V>> createReadOnlyExpression() {
        if (this.changeAwareMap == null) {
            ChangeAwareMap readOnlyMap = ChangeAwareMaps.ofUnmodifiable(() -> ((MapProperty)this).getSafe());
            return () -> this.lambda$createReadOnlyExpression$1((Map)readOnlyMap);
        }
        ChangeAwareMap readOnlyMap = ChangeAwareMaps.ofUnmodifiable(this.changeAwareMap);
        return () -> MapProperty.lambda$createReadOnlyExpression$2((Map)readOnlyMap);
    }

    private static /* synthetic */ Map lambda$createReadOnlyExpression$2(Map readOnlyMap) {
        return readOnlyMap;
    }

    private /* synthetic */ Map lambda$createReadOnlyExpression$1(Map readOnlyMap) {
        Map result = (Map)this.get();
        if (result == null) {
            return null;
        }
        return readOnlyMap;
    }
}

