/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.container.set;

import io.github.mmm.event.EventListener;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.WritableProperty;
import io.github.mmm.property.container.collection.CollectionProperty;
import io.github.mmm.property.container.set.WritableSetProperty;
import io.github.mmm.value.observable.container.set.ChangeAwareSet;
import io.github.mmm.value.observable.container.set.ChangeAwareSets;
import io.github.mmm.value.observable.container.set.SetChangeListener;
import java.util.Set;
import java.util.function.Supplier;

public class SetProperty<E>
extends CollectionProperty<Set<E>, E>
implements WritableSetProperty<E> {
    private Set<E> value;
    private ChangeAwareSet<E> changeAwareSet;

    public SetProperty(String name, WritableProperty<E> valueProperty) {
        super(name, valueProperty);
    }

    public SetProperty(String name, WritableProperty<E> valueProperty, PropertyMetadata<Set<E>> metadata) {
        super(name, valueProperty, metadata);
    }

    protected Set<E> doGet() {
        if (this.changeAwareSet != null) {
            return this.changeAwareSet;
        }
        return this.value;
    }

    protected void doSet(Set<E> newValue) {
        if (this.changeAwareSet != null) {
            if (newValue == null) {
                this.changeAwareSet.clear();
            } else {
                this.changeAwareSet.setAll(newValue);
            }
        } else {
            this.value = newValue;
        }
    }

    @Override
    public boolean isChangeAware() {
        return this.changeAwareSet != null;
    }

    @Override
    public ChangeAwareSet<E> getChangeAwareValue() {
        if (this.changeAwareSet == null) {
            this.changeAwareSet = ChangeAwareSets.of((Set)((Set)this.getOrCreate()));
            this.changeAwareSet.addListener((EventListener)((SetChangeListener)change -> {
                this.invalidateProperties();
                this.fireChange(change);
            }));
        }
        return this.changeAwareSet;
    }

    @Override
    protected Supplier<? extends Set<E>> createReadOnlyExpression() {
        if (this.changeAwareSet == null) {
            ChangeAwareSet readOnlySet = ChangeAwareSets.ofUnmodifiable(() -> ((SetProperty)this).getSafe());
            return () -> this.lambda$createReadOnlyExpression$1((Set)readOnlySet);
        }
        ChangeAwareSet readOnlySet = ChangeAwareSets.ofUnmodifiable(this.changeAwareSet);
        return () -> SetProperty.lambda$createReadOnlyExpression$2((Set)readOnlySet);
    }

    private static /* synthetic */ Set lambda$createReadOnlyExpression$2(Set readOnlySet) {
        return readOnlySet;
    }

    private /* synthetic */ Set lambda$createReadOnlyExpression$1(Set readOnlySet) {
        Set result = (Set)this.get();
        if (result == null) {
            return null;
        }
        return readOnlySet;
    }
}

