/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.criteria;

import io.github.mmm.base.io.AppendableWriter;
import io.github.mmm.property.criteria.CriteriaExpression;
import io.github.mmm.property.criteria.CriteriaOperator;
import io.github.mmm.property.criteria.CriteriaOrdering;
import io.github.mmm.property.criteria.CriteriaParameters;
import io.github.mmm.property.criteria.CriteriaVisitor;
import io.github.mmm.property.criteria.LikePatternSyntax;
import io.github.mmm.property.criteria.Literal;
import io.github.mmm.property.criteria.PredicateOperator;
import io.github.mmm.property.criteria.ProjectionProperty;
import io.github.mmm.property.criteria.PropertyPathHelper;
import io.github.mmm.property.criteria.impl.CriteriaParametersInline;
import io.github.mmm.value.CriteriaObject;
import io.github.mmm.value.PropertyPath;
import io.github.mmm.value.ReadablePath;
import java.util.List;

public class CriteriaFormatter
implements CriteriaVisitor {
    protected final AppendableWriter out;
    private final CriteriaParameters<?> parameters;
    private LikePatternSyntax likeSyntaxSource;
    private LikePatternSyntax likeSyntaxTarget;

    public CriteriaFormatter() {
        this(null);
    }

    protected CriteriaFormatter(CriteriaParameters<?> parameters) {
        this(parameters, null);
    }

    protected CriteriaFormatter(CriteriaParameters<?> parameters, AppendableWriter out) {
        this.parameters = parameters == null ? CriteriaParametersInline.get() : parameters;
        this.out = out == null ? new AppendableWriter() : out;
        this.likeSyntaxTarget = LikePatternSyntax.SQL;
    }

    public LikePatternSyntax getLikeSyntaxSource() {
        return this.likeSyntaxSource;
    }

    public void setLikeSyntaxSource(LikePatternSyntax likeSyntaxSource) {
        this.likeSyntaxSource = likeSyntaxSource;
    }

    public LikePatternSyntax getLikeSyntaxTarget() {
        return this.likeSyntaxTarget;
    }

    public void setLikeSyntaxTarget(LikePatternSyntax likeSyntaxTarget) {
        this.likeSyntaxTarget = likeSyntaxTarget;
    }

    protected void write(String text) {
        this.out.append((CharSequence)text);
    }

    public AppendableWriter out() {
        return this.out;
    }

    public CriteriaParameters<?> getParameters() {
        return this.parameters;
    }

    @Override
    public CriteriaFormatter onExpression(CriteriaExpression<?> expression, CriteriaExpression<?> parent) {
        int argCount;
        CriteriaOperator op = expression.getOperator();
        boolean useBrackets = false;
        if (op.isConjunction()) {
            if (op.isInverse()) {
                useBrackets = true;
                this.write("NOT(");
                op = op.not();
            } else {
                useBrackets = CriteriaFormatter.isUseBrackets(expression, parent);
                if (useBrackets) {
                    this.write("(");
                }
            }
        }
        if ((argCount = expression.getArgCount()) <= 2) {
            if (argCount == 0) {
                this.onOperator(op);
            } else if (op.isInfix()) {
                this.onArg(expression.getFirstArg(), 0, expression);
                this.write(" ");
                this.onOperator(op);
            } else {
                this.onOperator(op);
                this.write("(");
                useBrackets = true;
                this.onArg(expression.getFirstArg(), 0, expression);
            }
            if (argCount == 2) {
                this.write(" ");
                this.onArg(expression.getSecondArg(), 1, expression);
            }
        } else {
            List<CriteriaObject<?>> args = expression.getArgs();
            assert (args.size() == argCount);
            Object separator = ",";
            if (op.isInfix()) {
                separator = " " + op.toString() + " ";
            } else {
                assert (!op.isUnary());
                this.onOperator(op);
                useBrackets = true;
                this.write("(");
            }
            Object s = "";
            for (int i = 0; i < argCount; ++i) {
                this.write((String)s);
                this.onArg(args.get(i), i, expression);
                s = separator;
            }
        }
        if (useBrackets) {
            this.write(")");
        }
        return this;
    }

    public static boolean isUseBrackets(CriteriaExpression<?> expression, CriteriaExpression<?> parent) {
        CriteriaOperator op = expression.getOperator();
        if (parent == null) {
            return false;
        }
        if (op.isInverse()) {
            return true;
        }
        CriteriaOperator parentOp = parent.getOperator();
        if (op == parentOp) {
            return false;
        }
        if (!parentOp.isConjunction()) {
            return false;
        }
        return parentOp != PredicateOperator.OR;
    }

    @Override
    public void onOperator(CriteriaOperator operator) {
        this.write(operator.toString());
    }

    @Override
    public void onPropertyPath(PropertyPath<?> property, int i, CriteriaExpression<?> parent) {
        this.write(property.path());
    }

    @Override
    public void onProjectionProperty(ProjectionProperty<?> arg, int i, CriteriaExpression<?> parent) {
        CriteriaObject<?> selection = arg.getSelection();
        this.onArg(selection, i, parent);
        PropertyPath<?> property = arg.getProperty();
        boolean writeAlias = true;
        if (selection instanceof PropertyPath) {
            boolean bl = writeAlias = !PropertyPathHelper.isEqualPath((ReadablePath)((PropertyPath)selection), property, true);
        }
        if (writeAlias) {
            this.write(" ");
            this.onAlias(property.path());
        }
    }

    public void onAlias(String alias) {
        this.write(alias);
    }

    @Override
    public void onLiteral(Literal<?> literal, int i, CriteriaExpression<?> parent) {
        Object value;
        CriteriaOperator op;
        if (this.likeSyntaxSource != this.likeSyntaxTarget && parent != null && PredicateOperator.isLikeBased(op = parent.getOperator()) && (value = literal.get()) instanceof String) {
            String pattern = (String)value;
            literal = Literal.of(this.likeSyntaxTarget.convert(pattern, this.likeSyntaxSource));
        }
        this.parameters.onLiteral(literal, this.out, parent);
        CriteriaVisitor.super.onLiteral(literal, i, parent);
    }

    @Override
    public void onNullValue(int i, CriteriaExpression<?> parent) {
        this.write("null");
        CriteriaVisitor.super.onNullValue(i, parent);
    }

    protected String convertLikePattern(String glob) {
        int length = glob.length();
        StringBuilder sb = new StringBuilder(length + 2);
        int i = 0;
        while (i < length) {
        }
        return sb.toString();
    }

    @Override
    public void onUndefinedArg(CriteriaObject<?> arg, int i, CriteriaExpression<?> parent) {
        this.write(arg.toString());
        CriteriaVisitor.super.onUndefinedArg(arg, i, parent);
    }

    public void onOrdering(CriteriaOrdering ordering) {
        this.onPropertyPath(ordering.getProperty(), 0, null);
        this.write(" ");
        this.write(ordering.getOrder().name());
    }

    public String toString() {
        return this.out.toString();
    }

    public static CriteriaFormatter of(CriteriaParameters<?> parameters) {
        return CriteriaFormatter.of(parameters, new StringBuilder());
    }

    public static CriteriaFormatter of(CriteriaParameters<?> parameters, Appendable appendable) {
        return CriteriaFormatter.of(parameters, new AppendableWriter(appendable));
    }

    public static CriteriaFormatter of(CriteriaParameters<?> parameters, AppendableWriter appendable) {
        return new CriteriaFormatter(parameters, appendable);
    }
}

