/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.criteria;

import io.github.mmm.base.exception.ObjectNotFoundException;
import io.github.mmm.base.sort.SortOrder;
import io.github.mmm.marshall.Marshalling;
import io.github.mmm.marshall.StructuredReader;
import io.github.mmm.marshall.StructuredState;
import io.github.mmm.marshall.StructuredWriter;
import io.github.mmm.marshall.id.StructuredIdMapping;
import io.github.mmm.marshall.id.StructuredIdMappingObject;
import io.github.mmm.property.criteria.CriteriaExpression;
import io.github.mmm.property.criteria.CriteriaOperator;
import io.github.mmm.property.criteria.CriteriaOrdering;
import io.github.mmm.property.criteria.CriteriaPredicate;
import io.github.mmm.property.criteria.Literal;
import io.github.mmm.property.criteria.ProjectionProperty;
import io.github.mmm.property.criteria.PropertyAssignment;
import io.github.mmm.value.CriteriaObject;
import io.github.mmm.value.PropertyPath;
import io.github.mmm.value.SimplePath;
import java.util.ArrayList;

public class CriteriaMarshalling
implements Marshalling<CriteriaExpression<?>>,
StructuredIdMappingObject {
    private static final String OPERATOR = "Operator";
    public static final String NAME_OPERATOR = "op";
    public static final String NAME_ARGUMENTS = "args";
    public static final String NAME_PROPERTY = "path";
    public static final String NAME_SORT_ORDER = "order";
    public static final String NAME_VALUE = "value";
    public static final String NAME_SELECTION_PROPERTY = "pp";
    public static final String NAME_SELECTION_EXPRESSION = "pe";
    public static final String NAME_PROJECTION_PROPERTY = "as";
    private static final CriteriaMarshalling INSTANCE = new CriteriaMarshalling();

    protected CriteriaMarshalling() {
    }

    public void writeObject(StructuredWriter writer, CriteriaExpression<?> expression) {
        this.writeExpression(writer, expression);
    }

    public void writeExpression(StructuredWriter writer, CriteriaExpression<?> expression) {
        writer.writeStartObject((StructuredIdMappingObject)this);
        writer.writeName(NAME_OPERATOR);
        CriteriaOperator op = expression.getOperator();
        writer.writeValueAsString(op.getSyntax());
        writer.writeName(NAME_ARGUMENTS);
        writer.writeStartArray();
        for (CriteriaObject<?> arg : expression.getArgs()) {
            this.writeArg(writer, arg);
        }
        writer.writeEnd();
        writer.writeEnd();
    }

    public void writeArg(StructuredWriter writer, CriteriaObject<?> arg) {
        if (arg instanceof CriteriaExpression) {
            this.writeExpression(writer, (CriteriaExpression)arg);
        } else if (arg instanceof PropertyPath) {
            this.writeProperty(writer, (PropertyPath)arg);
        } else if (arg instanceof ProjectionProperty) {
            this.writeProjectionProperty(writer, (ProjectionProperty)arg);
        } else if (arg instanceof Literal) {
            this.writeLiteral(writer, (Literal)arg);
        } else {
            writer.writeValue((Object)arg.toString());
        }
    }

    public void writeProperty(StructuredWriter writer, PropertyPath<?> property) {
        writer.writeStartObject((StructuredIdMappingObject)this);
        writer.writeName(NAME_PROPERTY);
        writer.writeValueAsString(property.path());
        writer.writeEnd();
    }

    public void writeProjectionProperty(StructuredWriter writer, ProjectionProperty<?> projectionProperty) {
        writer.writeStartObject((StructuredIdMappingObject)this);
        CriteriaObject<?> selection = projectionProperty.getSelection();
        if (selection instanceof PropertyPath) {
            writer.writeName(NAME_SELECTION_PROPERTY);
            writer.writeValueAsString(((PropertyPath)selection).path());
        } else if (selection instanceof CriteriaExpression) {
            writer.writeName(NAME_SELECTION_EXPRESSION);
            this.writeExpression(writer, (CriteriaExpression)selection);
        } else {
            throw new IllegalStateException();
        }
        writer.writeName(NAME_PROJECTION_PROPERTY);
        writer.writeValueAsString(projectionProperty.getProperty().path());
        writer.writeEnd();
    }

    public void writeLiteral(StructuredWriter writer, Literal<?> literal) {
        writer.writeValue(literal.get());
    }

    public void writeOrdering(StructuredWriter writer, CriteriaOrdering ordering) {
        writer.writeStartObject((StructuredIdMappingObject)this);
        writer.writeName(NAME_PROPERTY);
        writer.writeValueAsString(ordering.getProperty().path());
        writer.writeName(NAME_SORT_ORDER);
        writer.writeValueAsString(ordering.getOrder().name());
        writer.writeEnd();
    }

    public void writeAssignment(StructuredWriter writer, PropertyAssignment<?> assignment) {
        writer.writeStartObject((StructuredIdMappingObject)this);
        writer.writeName(NAME_PROPERTY);
        writer.writeValueAsString(assignment.getProperty().path());
        writer.writeName(NAME_VALUE);
        this.writeArg(writer, assignment.getValue());
        writer.writeEnd();
    }

    public CriteriaExpression<?> readObject(StructuredReader reader) {
        return this.readExpression(reader);
    }

    public CriteriaExpression<?> readExpression(StructuredReader reader) {
        reader.require(StructuredState.START_OBJECT, true);
        return this.readExpressionInteral(reader);
    }

    private CriteriaExpression<?> readExpressionInteral(StructuredReader reader) {
        CriteriaOperator op = null;
        ArrayList args = null;
        while (!reader.readEnd()) {
            String name = reader.readName();
            if (NAME_OPERATOR.equals(name)) {
                assert (op == null);
                String syntax = reader.readValueAsString();
                op = CriteriaOperator.of(syntax);
                if (op != null) continue;
                throw new ObjectNotFoundException((Object)OPERATOR, (Object)syntax);
            }
            if (NAME_ARGUMENTS.equals(name)) {
                assert (args == null);
                args = new ArrayList();
                reader.require(StructuredState.START_ARRAY, true);
                while (!reader.readEnd()) {
                    CriteriaObject<?> arg = this.readArg(reader);
                    args.add(arg);
                }
                continue;
            }
            reader.skipValue();
        }
        if (op == null) {
            throw new ObjectNotFoundException((Object)OPERATOR);
        }
        return op.expression(args);
    }

    public CriteriaPredicate readPredicate(StructuredReader reader) {
        CriteriaExpression<?> expression = this.readExpression(reader);
        if (expression instanceof CriteriaPredicate) {
            return (CriteriaPredicate)expression;
        }
        throw new IllegalStateException("Expression is not a predicate: " + String.valueOf(expression));
    }

    public CriteriaObject<?> readArg(StructuredReader reader) {
        if (reader.getState() == StructuredState.START_OBJECT) {
            reader.next();
            String name = reader.getName();
            if (NAME_PROPERTY.equals(name)) {
                reader.readName();
                return this.readProperty(reader);
            }
            if (NAME_SELECTION_PROPERTY.equals(name) || NAME_SELECTION_EXPRESSION.equals(name) || NAME_PROJECTION_PROPERTY.equals(name)) {
                return this.readProjectionProperty(reader);
            }
            return this.readExpressionInteral(reader);
        }
        return this.readLiteral(reader);
    }

    public Literal<?> readLiteral(StructuredReader reader) {
        return Literal.of(reader.readValue());
    }

    public PropertyPath<?> readProperty(StructuredReader reader) {
        String path = reader.readValueAsString();
        reader.require(StructuredState.END_OBJECT, true);
        return SimplePath.of((String)path);
    }

    private ProjectionProperty<?> readProjectionProperty(StructuredReader reader) {
        Object selection = null;
        SimplePath property = null;
        while (!reader.readEnd()) {
            String path;
            String name = reader.readName();
            if (NAME_SELECTION_PROPERTY.equals(name)) {
                assert (selection == null);
                path = reader.readValueAsString();
                selection = SimplePath.of((String)path);
                continue;
            }
            if (NAME_SELECTION_EXPRESSION.equals(name)) {
                assert (selection == null);
                selection = this.readExpression(reader);
                continue;
            }
            if (NAME_PROJECTION_PROPERTY.equals(name)) {
                assert (property == null);
                path = reader.readValueAsString();
                property = SimplePath.of((String)path);
                continue;
            }
            reader.skipValue();
        }
        return new ProjectionProperty(selection, property);
    }

    public CriteriaOrdering readOrdering(StructuredReader reader) {
        reader.require(StructuredState.START_OBJECT, true);
        SimplePath property = null;
        SortOrder order = null;
        while (!reader.readEnd()) {
            String name = reader.readName();
            if (NAME_PROPERTY.equals(name)) {
                String p = reader.readValueAsString();
                property = SimplePath.of((String)p);
                continue;
            }
            if (NAME_SORT_ORDER.equals(name)) {
                String o = reader.readValueAsString();
                order = SortOrder.valueOf((String)o);
                continue;
            }
            reader.skipValue();
        }
        if (property == null) {
            throw new ObjectNotFoundException((Object)NAME_PROPERTY);
        }
        if (order == null) {
            throw new ObjectNotFoundException((Object)NAME_SORT_ORDER);
        }
        return new CriteriaOrdering((PropertyPath<?>)property, order);
    }

    public PropertyAssignment<?> readAssignment(StructuredReader reader) {
        reader.require(StructuredState.START_OBJECT, true);
        SimplePath property = null;
        CriteriaObject<?> value = null;
        boolean hasValue = false;
        while (!reader.readEnd()) {
            String name = reader.readName();
            if (NAME_PROPERTY.equals(name)) {
                String p = reader.readValueAsString();
                property = SimplePath.of((String)p);
                continue;
            }
            if (NAME_VALUE.equals(name)) {
                value = this.readArg(reader);
                hasValue = true;
                continue;
            }
            reader.skipValue();
        }
        if (property == null) {
            throw new ObjectNotFoundException((Object)NAME_PROPERTY);
        }
        if (!hasValue) {
            throw new ObjectNotFoundException((Object)NAME_VALUE);
        }
        return new PropertyAssignment(property, value);
    }

    public StructuredIdMapping defineIdMapping() {
        return StructuredIdMapping.of((String[])new String[]{NAME_OPERATOR, NAME_VALUE, NAME_PROPERTY, NAME_ARGUMENTS, NAME_SORT_ORDER, NAME_PROJECTION_PROPERTY, NAME_SELECTION_EXPRESSION, NAME_SELECTION_PROPERTY});
    }

    public static CriteriaMarshalling get() {
        return INSTANCE;
    }
}

