/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.criteria;

import io.github.mmm.base.filter.CharFilter;
import io.github.mmm.base.text.CaseHelper;
import io.github.mmm.property.criteria.BooleanLiteral;
import io.github.mmm.property.criteria.CriteriaAggregationOperator;
import io.github.mmm.property.criteria.CriteriaExpression;
import io.github.mmm.property.criteria.CriteriaOperator;
import io.github.mmm.property.criteria.CriteriaPredicate;
import io.github.mmm.property.criteria.Literal;
import io.github.mmm.property.criteria.PredicateOperator;
import io.github.mmm.property.criteria.PropertyPathParser;
import io.github.mmm.property.criteria.SimplePathParser;
import io.github.mmm.property.criteria.impl.CriteriaAggregationImpl;
import io.github.mmm.property.criteria.impl.SimplePredicate;
import io.github.mmm.scanner.CharScannerParser;
import io.github.mmm.scanner.CharStreamScanner;
import io.github.mmm.value.CriteriaObject;
import io.github.mmm.value.PropertyPath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public class CriteriaObjectParser
implements CharScannerParser<CriteriaObject<?>> {
    private static CriteriaObjectParser INSTANCE = new CriteriaObjectParser();
    private static final CharFilter OP_FILTER = c -> c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 43 || c == 45 || c == 60 || c == 62 || c == 61;
    private static final CharFilter NUMER_FILTER = c -> c >= 48 && c <= 57 || c == 101 || c == 69 || c == 43 || c == 45 || c == 46;

    public CriteriaObject<?> parse(CharStreamScanner scanner) {
        return this.parse(scanner, SimplePathParser.INSTANCE);
    }

    public CriteriaObject<?> parse(CharStreamScanner scanner, PropertyPathParser pathParser) {
        int cp = scanner.peek();
        if (cp == 40) {
            scanner.next();
            scanner.skipWhile(32);
            CriteriaObject<?> expression = this.parse(scanner);
            scanner.skipWhile(32);
            if (!scanner.expectOne(41)) {
                throw new IllegalArgumentException("Missing ')'.");
            }
            return expression;
        }
        return this.parse(scanner, pathParser, null, null);
    }

    private CriteriaObject<?> parse(CharStreamScanner scanner, PropertyPathParser pathParser, CriteriaObject<?> expression, CriteriaOperator operator) {
        ArrayList<Object> expressions = null;
        if (expression != null) {
            assert (operator != null);
            expressions = new ArrayList();
            expressions.add(expression);
        }
        while (true) {
            expression = scanner.peek() == 40 ? this.parse(scanner) : this.parsePredicate(scanner, pathParser);
            if (expressions != null) {
                expressions.add(expression);
            }
            int spaces = scanner.skipWhile(32);
            int cp = scanner.peek();
            if (cp == 44 || cp == 41 || cp == 0 || (cp == 111 || cp == 79 ? scanner.expect("ORDER BY ", true, true) : (cp == 103 || cp == 71 ? scanner.expect("GROUP BY ", true, true) : (cp == 104 || cp == 72) && scanner.expect("HAVING ", true, true)))) break;
            CriteriaOperator newOp = this.parseOperator(scanner);
            spaces = scanner.skipWhile(32);
            assert (spaces > 0);
            if (expressions == null) {
                expressions = new ArrayList();
                expressions.add(expression);
            }
            if (operator == null) {
                operator = newOp;
                continue;
            }
            if (newOp == operator) continue;
            if (newOp.getPriority() > operator.getPriority()) {
                expressions.remove(expressions.size() - 1);
                expression = this.parse(scanner, pathParser, (CriteriaObject<?>)expression, newOp);
                continue;
            }
            expressions.add(expression);
            expression = operator.expression(expressions);
            expressions.clear();
        }
        if (expressions != null) {
            assert (operator != null);
            expression = operator.expression(expressions);
        }
        return expression;
    }

    public CriteriaObject<?> parseSelection(CharStreamScanner scanner, PropertyPathParser pathParser) {
        Literal<?> literal = this.parseLiteral(scanner);
        if (literal != null) {
            return literal;
        }
        String segment = PropertyPathParser.parseSegment(scanner);
        CriteriaOperator operator = this.parseOperator(segment);
        if (operator != null) {
            CriteriaExpression result;
            assert (!operator.isInfix()) : operator.toString();
            scanner.skipWhile(32);
            scanner.requireOne(40);
            if (operator instanceof CriteriaAggregationOperator) {
                CriteriaObject<?> arg = this.parseSelection(scanner, pathParser);
                CriteriaAggregationOperator aggOp = (CriteriaAggregationOperator)operator;
                result = new CriteriaAggregationImpl(aggOp, arg);
            } else if (operator == PredicateOperator.NOT) {
                CriteriaObject<?> arg = this.parse(scanner);
                result = arg instanceof CriteriaPredicate ? ((CriteriaPredicate)arg).not() : new SimplePredicate(arg, PredicateOperator.NOT, null);
            } else {
                throw new IllegalStateException("Invalid operator at this place: " + String.valueOf(operator));
            }
            scanner.skipWhile(32);
            scanner.requireOne(41);
            return result;
        }
        if (scanner.expectOne(46)) {
            PropertyPath<?> path = pathParser.parse(scanner, segment);
            return path;
        }
        throw new IllegalArgumentException();
    }

    public Literal<?> parseLiteral(CharStreamScanner scanner) {
        int cp = scanner.peek();
        if (cp == 39) {
            scanner.next();
            String string = scanner.readUntil(cp, false, cp);
            return Literal.of(string);
        }
        if ((cp == 116 || cp == 84) && scanner.expect("TRUE", true)) {
            return BooleanLiteral.TRUE;
        }
        if ((cp == 102 || cp == 70) && scanner.expect("FALSE", true)) {
            return BooleanLiteral.FALSE;
        }
        if (cp == 43 || cp == 45 || CharFilter.LATIN_DIGIT.accept(cp)) {
            String num = scanner.readWhile(NUMER_FILTER);
            int len = num.length();
            if (cp == 43 || cp == 45) {
                --len;
            }
            Number number = num.indexOf(46) >= 0 || num.indexOf(101) > 0 || num.indexOf(69) > 0 ? new BigDecimal(num) : (len <= 10 ? (Number)Integer.valueOf(num) : (Number)(len <= 19 ? Long.valueOf(num) : new BigInteger(num)));
            return Literal.of(number);
        }
        return null;
    }

    private PredicateOperator parsePredicateOperator(CharStreamScanner scanner) {
        CriteriaOperator op = this.parseOperator(scanner);
        if (op instanceof PredicateOperator) {
            return (PredicateOperator)op;
        }
        throw new IllegalArgumentException("Expected predicate operator but found '" + String.valueOf(op) + "'.");
    }

    private CriteriaOperator parseOperator(CharStreamScanner scanner) {
        String op = scanner.readWhile(OP_FILTER);
        CriteriaOperator operator = this.parseOperator(op);
        if (operator == null) {
            throw new IllegalArgumentException("Invalid operator '" + op + "'.");
        }
        return operator;
    }

    private CriteriaOperator parseOperator(String token) {
        return CriteriaOperator.of(CaseHelper.toUpperCase((String)token));
    }

    public CriteriaPredicate parsePredicate(CharStreamScanner scanner, PropertyPathParser pathParser) {
        CriteriaObject<?> arg1 = this.parseSelection(scanner, pathParser);
        scanner.skipWhile(32);
        PredicateOperator operator = this.parsePredicateOperator(scanner);
        scanner.skipWhile(32);
        CriteriaObject<?> arg2 = this.parseSelection(scanner, pathParser);
        return new SimplePredicate(arg1, operator, arg2);
    }

    public CriteriaObject<?> parseSelection(CharStreamScanner scanner) {
        return this.parseSelection(scanner, SimplePathParser.INSTANCE);
    }

    public static CriteriaObjectParser get() {
        return INSTANCE;
    }
}

