/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.criteria;

import io.github.mmm.property.criteria.CriteriaAggregationOperator;
import io.github.mmm.property.criteria.CriteriaExpression;
import io.github.mmm.property.criteria.PredicateOperator;
import io.github.mmm.value.CriteriaObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CriteriaOperator {
    protected static final int PRIO_1_TILDE = 1;
    protected static final int PRIO_2_MUL = 2;
    protected static final int PRIO_3_ADD = 3;
    protected static final int PRIO_4_COMP = 4;
    protected static final int PRIO_5_NOT = 5;
    protected static final int PRIO_6_AND = 6;
    protected static final int PRIO_7_OR = 7;
    protected static final int PRIO_8_ASSIGN = 8;
    private static final Map<String, CriteriaOperator> SYNTAX2OPERATOR_MAP = new HashMap<String, CriteriaOperator>();
    private final String syntax;
    private final String name;
    private final boolean inverse;
    private CriteriaOperator not;

    protected CriteriaOperator(String syntax) {
        this(syntax, null);
    }

    protected CriteriaOperator(String syntax, CriteriaOperator not) {
        this(syntax, not, not != null);
    }

    protected CriteriaOperator(String syntax, CriteriaOperator not, boolean inverse) {
        this(syntax, not, inverse, null);
    }

    protected CriteriaOperator(String syntax, CriteriaOperator not, boolean inverse, String name) {
        assert (syntax != null && !syntax.isEmpty()) : syntax;
        this.syntax = syntax;
        this.name = name == null ? syntax.replace(' ', '_') : name;
        assert (this.isValidName()) : this.name;
        this.inverse = inverse;
        if (not != null) {
            this.not = not;
            if (not.not != this) {
                if (not.not != null) {
                    throw new IllegalStateException("Negation of '" + syntax + "' cannot be '" + String.valueOf(not) + "' as this already has negation '" + String.valueOf(not.not) + "'!");
                }
                not.not = this;
            }
        }
        CriteriaOperator duplicate = SYNTAX2OPERATOR_MAP.putIfAbsent(syntax, this);
        assert (duplicate == null);
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public abstract boolean isUnary();

    public boolean isConjunction() {
        return false;
    }

    public CriteriaOperator not() {
        return this.not;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public String getName() {
        return this.name;
    }

    private boolean isValidName() {
        int length = this.name.length();
        if (length == 0) {
            return false;
        }
        for (int i = length - 1; i >= 0; --i) {
            boolean valid;
            char c = this.name.charAt(i);
            boolean bl = valid = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
            if (valid) continue;
            return false;
        }
        return true;
    }

    public boolean isInfix() {
        return !this.isUnary();
    }

    public abstract int getPriority();

    public abstract CriteriaExpression<?> expression(List<CriteriaObject<?>> var1);

    public String toString() {
        return this.syntax;
    }

    public static CriteriaOperator of(String syntax) {
        return SYNTAX2OPERATOR_MAP.get(syntax);
    }

    static {
        PredicateOperator.load();
        CriteriaAggregationOperator.load();
    }
}

