/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.criteria;

import io.github.mmm.property.criteria.BooleanSelection;
import io.github.mmm.property.criteria.CriteriaExpression;
import io.github.mmm.property.criteria.Literal;
import io.github.mmm.property.criteria.PredicateOperator;
import io.github.mmm.property.criteria.impl.ConjunctionPredicate;
import io.github.mmm.property.criteria.impl.SimplePredicate;
import io.github.mmm.value.CriteriaObject;
import io.github.mmm.value.PropertyPath;
import java.util.Collection;
import java.util.Objects;

public interface CriteriaPredicate
extends CriteriaExpression<Boolean>,
BooleanSelection {
    @Override
    public PredicateOperator getOperator();

    @Override
    public CriteriaPredicate not();

    default public CriteriaPredicate and(CriteriaPredicate predicate) {
        return new ConjunctionPredicate(PredicateOperator.AND, this, predicate);
    }

    default public CriteriaPredicate and(CriteriaPredicate ... predicates) {
        int length = predicates.length;
        if (length == 0) {
            return this;
        }
        BooleanSelection[] args = new CriteriaPredicate[length + 1];
        args[0] = this;
        System.arraycopy(predicates, 0, args, 1, length);
        return new ConjunctionPredicate(PredicateOperator.AND, args);
    }

    default public CriteriaPredicate or(CriteriaPredicate predicate) {
        return new ConjunctionPredicate(PredicateOperator.OR, this, predicate);
    }

    default public CriteriaPredicate or(CriteriaPredicate ... predicates) {
        int length = predicates.length;
        if (length == 0) {
            return this;
        }
        BooleanSelection[] args = new CriteriaPredicate[length + 1];
        args[0] = this;
        System.arraycopy(predicates, 0, args, 1, length);
        return new ConjunctionPredicate(PredicateOperator.OR, args);
    }

    @Override
    public CriteriaPredicate simplify();

    public static <V> CriteriaPredicate of(CriteriaObject<V> property, PredicateOperator op, V value) {
        Objects.requireNonNull(property);
        if (value == null) {
            if (op == PredicateOperator.EQ) {
                op = PredicateOperator.IS_NULL;
            } else if (op == PredicateOperator.NEQ) {
                op = PredicateOperator.IS_NOT_NULL;
            }
        }
        if (!1.$assertionsDisabled && op.isConjunction()) {
            throw new AssertionError();
        }
        return new SimplePredicate(property, op, Literal.of(value));
    }

    public static <V> CriteriaPredicate of(CriteriaObject<V> property, PredicateOperator op, PropertyPath<V> property2) {
        Objects.requireNonNull(property);
        Objects.requireNonNull(property2);
        return new SimplePredicate(property, op, (CriteriaObject<?>)property2);
    }

    public static <V> CriteriaPredicate of(V value, PredicateOperator op, PropertyPath<V> property) {
        Objects.requireNonNull(value);
        if (!1.$assertionsDisabled && op != PredicateOperator.LIKE && op != PredicateOperator.NOT_LIKE) {
            throw new AssertionError();
        }
        Objects.requireNonNull(property);
        return new SimplePredicate((CriteriaObject<?>)Literal.of(value), op, (CriteriaObject<?>)property);
    }

    public static <V> CriteriaPredicate ofIn(PropertyPath<V> property, Collection<V> values) {
        return CriteriaPredicate.of(property, PredicateOperator.IN, values);
    }

    public static <V> CriteriaPredicate ofNotIn(PropertyPath<V> property, Collection<V> values) {
        return CriteriaPredicate.of(property, PredicateOperator.NOT_IN, values);
    }

    private static <V> CriteriaPredicate of(PropertyPath<V> property, PredicateOperator op, Collection<V> values) {
        Objects.requireNonNull(property);
        if (values == null || values.isEmpty()) {
            if (op == PredicateOperator.IN) {
                return SimplePredicate.NEVER;
            }
            if (op == PredicateOperator.NOT_IN) {
                return SimplePredicate.ALWAYS;
            }
            throw new IllegalStateException();
        }
        if (values.size() == 1) {
            V value = values.iterator().next();
            if (op == PredicateOperator.IN) {
                return CriteriaPredicate.of(property, PredicateOperator.EQ, value);
            }
            if (op == PredicateOperator.NOT_IN) {
                return CriteriaPredicate.of(property, PredicateOperator.NEQ, value);
            }
            throw new IllegalStateException();
        }
        return new SimplePredicate((CriteriaObject<?>)property, op, (CriteriaObject<?>)Literal.of(values));
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

