/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.criteria;

import io.github.mmm.property.criteria.CriteriaExpression;
import io.github.mmm.property.criteria.CriteriaOperator;
import io.github.mmm.property.criteria.Literal;
import io.github.mmm.property.criteria.ProjectionProperty;
import io.github.mmm.value.CriteriaObject;
import io.github.mmm.value.PropertyPath;
import java.util.List;

public interface CriteriaVisitor {
    default public CriteriaVisitor onExpression(CriteriaExpression<?> expression) {
        return this.onExpression(expression, null);
    }

    default public CriteriaVisitor onExpression(CriteriaExpression<?> expression, CriteriaExpression<?> parent) {
        block3: {
            int argCount;
            block2: {
                this.onOperator(expression.getOperator());
                argCount = expression.getArgCount();
                if (argCount > 2) break block2;
                if (argCount <= 0) break block3;
                this.onArg(expression.getFirstArg(), 0, expression);
                if (argCount != 2) break block3;
                this.onArg(expression.getSecondArg(), 1, expression);
                break block3;
            }
            List<CriteriaObject<?>> args = expression.getArgs();
            if (!1.$assertionsDisabled && argCount != args.size()) {
                throw new AssertionError();
            }
            for (int i = 0; i < argCount; ++i) {
                this.onArg(args.get(i), i, expression);
            }
        }
        return this;
    }

    default public void onOperator(CriteriaOperator operator) {
    }

    default public void onArg(CriteriaObject<?> arg, int i, CriteriaExpression<?> parent) {
        if (arg == null) {
            this.onNullValue(i, parent);
        } else if (arg instanceof Literal) {
            Literal literal = (Literal)arg;
            this.onLiteral(literal, i, parent);
        } else if (arg instanceof PropertyPath) {
            PropertyPath property = (PropertyPath)arg;
            this.onPropertyPath(property, i, parent);
        } else if (arg instanceof CriteriaExpression) {
            CriteriaExpression expression = (CriteriaExpression)arg;
            this.onExpression(expression, parent);
        } else if (arg instanceof ProjectionProperty) {
            ProjectionProperty projection = (ProjectionProperty)arg;
            this.onProjectionProperty(projection, i, parent);
        } else {
            this.onUndefinedArg(arg, i, parent);
        }
    }

    default public void onProjectionProperty(ProjectionProperty<?> arg, int i, CriteriaExpression<?> parent) {
        this.onArg(arg.getSelection(), i, parent);
        this.onArg((CriteriaObject<?>)arg.getProperty(), i, parent);
    }

    default public void onUndefinedArg(CriteriaObject<?> arg, int i, CriteriaExpression<?> parent) {
    }

    default public void onPropertyPath(PropertyPath<?> property, int i, CriteriaExpression<?> parent) {
    }

    default public void onLiteral(Literal<?> literal, int i, CriteriaExpression<?> parent) {
    }

    default public void onNullValue(int i, CriteriaExpression<?> parent) {
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

