/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.criteria;

import io.github.mmm.base.exception.DuplicateObjectException;
import java.util.HashMap;
import java.util.Map;

public class LikePatternSyntax {
    private static final Map<String, LikePatternSyntax> NAME2SYNTAX_MAP = new HashMap<String, LikePatternSyntax>();
    public static final LikePatternSyntax GLOB = new LikePatternSyntax("Glob", '*', '?');
    public static final LikePatternSyntax SQL = new LikePatternSyntax("SQL", '%', '_');
    public static final char ESCAPE = '\\';
    private final String name;
    private final char any;
    private final char single;

    protected LikePatternSyntax(String name, char any, char single) {
        this.name = name;
        this.any = any;
        this.single = single;
        LikePatternSyntax old = NAME2SYNTAX_MAP.putIfAbsent(name, this);
        if (old != null) {
            throw new DuplicateObjectException((Object)this, (Object)name, (Object)old);
        }
    }

    public String getName() {
        return this.name;
    }

    public char getAny() {
        return this.any;
    }

    public char getSingle() {
        return this.single;
    }

    public String convert(String pattern, LikePatternSyntax syntax) {
        return this.convert(pattern, syntax, false);
    }

    public String convert(String pattern, LikePatternSyntax syntax, boolean matchSubstring) {
        if (pattern == null || pattern.isEmpty()) {
            if (matchSubstring) {
                return Character.toString(this.any);
            }
            return pattern;
        }
        if (syntax == null && (syntax = LikePatternSyntax.autoDetect(pattern)) == null) {
            syntax = this;
        }
        if (syntax == this) {
            Object result = pattern;
            if (matchSubstring) {
                int lastIndex;
                if (pattern.charAt(0) != this.any) {
                    result = this.any + (String)result;
                }
                if (pattern.charAt(lastIndex = pattern.length() - 1) != this.any || lastIndex > 0 && pattern.charAt(lastIndex - 1) == '\\') {
                    result = (String)result + this.any;
                }
            }
            return result;
        }
        int length = pattern.length();
        StringBuilder sb = new StringBuilder(length + 8);
        boolean lastWildcardAny = false;
        for (int i = 0; i < length; ++i) {
            lastWildcardAny = false;
            char c = pattern.charAt(i);
            if (c == syntax.any) {
                c = this.any;
                lastWildcardAny = true;
            } else if (c == syntax.single) {
                c = this.single;
            } else if (c == this.any || c == this.single) {
                if (i == 0 && matchSubstring) {
                    sb.append(this.any);
                }
                sb.append('\\');
            } else if (c == '\\') {
                int next = i + 1;
                if (next < length) {
                    c = pattern.charAt(next);
                    i = next;
                }
                if (c != syntax.any && c != syntax.single) {
                    sb.append('\\');
                    if (c != '\\') {
                        sb.append('\\');
                    }
                }
            }
            if (matchSubstring && i == 0 && !lastWildcardAny) {
                sb.append(this.any);
            }
            sb.append(c);
        }
        if (matchSubstring && !lastWildcardAny) {
            sb.append(this.any);
        }
        return sb.toString();
    }

    public static LikePatternSyntax autoDetect(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return null;
        }
        for (LikePatternSyntax syntax : NAME2SYNTAX_MAP.values()) {
            if (pattern.indexOf(syntax.any) >= 0) {
                return syntax;
            }
            if (pattern.indexOf(syntax.single) < 0) continue;
            return syntax;
        }
        return null;
    }

    public String toString() {
        return this.name + "(" + this.any + "," + this.single + ")";
    }
}

