/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.criteria;

import io.github.mmm.property.criteria.BooleanLiteral;
import io.github.mmm.property.criteria.impl.GenericLiteral;
import io.github.mmm.property.criteria.impl.NumberLiteral;
import io.github.mmm.property.criteria.impl.StringLiteral;
import io.github.mmm.property.criteria.impl.TemporalLiteral;
import io.github.mmm.value.CriteriaObject;
import java.time.temporal.Temporal;
import java.util.function.Supplier;

public interface Literal<V>
extends CriteriaObject<V>,
Supplier<V> {
    public static BooleanLiteral of(boolean value) {
        if (value) {
            return BooleanLiteral.TRUE;
        }
        return BooleanLiteral.FALSE;
    }

    public static BooleanLiteral of(Boolean value) {
        if (value == null) {
            return null;
        }
        return Literal.of((boolean)value);
    }

    public static Literal<String> of(String value) {
        if (value == null) {
            return null;
        }
        return new StringLiteral(value);
    }

    public static <N extends Number> Literal<N> of(N value) {
        if (value == null) {
            return null;
        }
        return new NumberLiteral<N>(value);
    }

    public static <T extends Temporal> Literal<T> of(T value) {
        if (value == null) {
            return null;
        }
        return new TemporalLiteral<T>(value);
    }

    public static <V> Literal<V> of(V value) {
        Literal<Boolean> literal = value == null ? null : (value instanceof Literal ? (BooleanLiteral)value : (value instanceof String ? Literal.of((String)value) : (value instanceof Boolean ? Literal.of((Boolean)value) : (value instanceof Number ? Literal.of((Number)value) : (value instanceof Temporal ? Literal.of((Temporal)value) : new GenericLiteral<V>(value))))));
        return literal;
    }
}

