/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.criteria;

import io.github.mmm.base.exception.ObjectNotFoundException;
import io.github.mmm.property.criteria.BooleanSelection;
import io.github.mmm.property.criteria.CriteriaOperator;
import io.github.mmm.property.criteria.CriteriaPredicate;
import io.github.mmm.property.criteria.impl.ConjunctionPredicate;
import io.github.mmm.property.criteria.impl.SimplePredicate;
import io.github.mmm.value.CriteriaObject;
import java.util.List;

public class PredicateOperator
extends CriteriaOperator {
    public static final PredicateOperator EQ = new PredicateOperator("=", 4, "EQ");
    public static final PredicateOperator NEQ = new PredicateOperator("<>", EQ, "NEQ");
    public static final PredicateOperator LT = new PredicateOperator("<", 4, "LT");
    public static final PredicateOperator LE = new PredicateOperator("<=", 4, "LE");
    public static final PredicateOperator GT = new PredicateOperator(">", false, LE, "GT");
    public static final PredicateOperator GE = new PredicateOperator(">=", false, LT, "GE");
    public static final PredicateOperator IS_NULL = new PredicateOperator("IS NULL", true, 4);
    public static final PredicateOperator IS_NOT_NULL = new PredicateOperator("IS NOT NULL", IS_NULL);
    public static final PredicateOperator LIKE = new PredicateOperator("LIKE", 7);
    public static final PredicateOperator NOT_LIKE = new PredicateOperator("NOT LIKE", LIKE);
    public static final PredicateOperator IN = new PredicateOperator("IN", 7);
    public static final PredicateOperator NOT_IN = new PredicateOperator("NOT IN", IN);
    public static final PredicateOperator CONTAINS = new PredicateOperator("CONTAINS", 7);
    public static final PredicateOperator NOT_CONTAINS = new PredicateOperator("NOT CONTAINS", CONTAINS);
    public static final PredicateOperator AND = new PredicateOperator("AND", 6);
    public static final PredicateOperator NAND = new PredicateOperator("NAND", AND);
    public static final PredicateOperator OR = new PredicateOperator("OR", 7);
    public static final PredicateOperator NOR = new PredicateOperator("NOR", OR);
    public static final PredicateOperator NOT = new PredicateOperator("NOT", true, null, true, 5);
    private final boolean unary;
    private final int priority;

    protected PredicateOperator(String syntax, int priority) {
        this(syntax, priority, null);
    }

    protected PredicateOperator(String syntax, int priority, String name) {
        this(syntax, false, null, false, priority, name);
    }

    protected PredicateOperator(String syntax, PredicateOperator not) {
        this(syntax, not, null);
    }

    protected PredicateOperator(String syntax, PredicateOperator not, String name) {
        this(syntax, true, not, name);
    }

    protected PredicateOperator(String syntax, boolean unary, int priority) {
        this(syntax, false, null, unary, priority);
    }

    protected PredicateOperator(String syntax, boolean inverse, PredicateOperator not) {
        this(syntax, inverse, not, not.unary, not.priority);
    }

    protected PredicateOperator(String syntax, boolean inverse, PredicateOperator not, String name) {
        this(syntax, inverse, not, not.unary, not.priority, name);
    }

    protected PredicateOperator(String syntax, boolean inverse, PredicateOperator not, boolean unary, int priority) {
        this(syntax, inverse, not, unary, priority, null);
    }

    protected PredicateOperator(String syntax, boolean inverse, PredicateOperator not, boolean unary, int priority, String name) {
        super(syntax, not, inverse, name);
        this.unary = unary;
        this.priority = priority;
    }

    @Override
    public PredicateOperator not() {
        return (PredicateOperator)super.not();
    }

    @Override
    public boolean isConjunction() {
        if (this == AND) {
            return true;
        }
        if (this == OR) {
            return true;
        }
        if (this == NAND) {
            return true;
        }
        return this == NOR;
    }

    @Override
    public boolean isUnary() {
        return this.unary;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean isInfix() {
        if (PredicateOperator.isNullBased(this)) {
            return true;
        }
        return super.isInfix();
    }

    public CriteriaPredicate expression(List<CriteriaObject<?>> args) {
        if (args == null || args.isEmpty()) {
            throw new ObjectNotFoundException((Object)"Arguments");
        }
        if (this.isConjunction()) {
            BooleanSelection[] predicates = new BooleanSelection[args.size()];
            int i = 0;
            try {
                for (CriteriaObject<?> arg : args) {
                    predicates[i] = (BooleanSelection)arg;
                    ++i;
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Argument at index " + i + " is not a BooleanSupplier (predicate).", e);
            }
            return new ConjunctionPredicate(this, predicates);
        }
        int argCount = args.size();
        if (argCount <= 2) {
            CriteriaObject<?> arg1 = args.get(0);
            CriteriaObject<?> arg2 = null;
            if (argCount > 1) {
                arg2 = args.get(1);
            }
            if (this == NOT == (argCount == 1)) {
                return new SimplePredicate(arg1, this, arg2);
            }
        }
        throw new IllegalArgumentException("Operator '" + String.valueOf(this) + "' does not accept " + argCount + " arguments");
    }

    public static PredicateOperator of(String syntax) {
        CriteriaOperator op = CriteriaOperator.of(syntax);
        if (op instanceof PredicateOperator) {
            return (PredicateOperator)op;
        }
        return null;
    }

    public static boolean isLikeBased(CriteriaOperator op) {
        return op == LIKE || op == NOT_LIKE;
    }

    public static boolean isNullBased(CriteriaOperator op) {
        return op == IS_NULL || op == IS_NOT_NULL;
    }

    static void load() {
    }
}

