/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.criteria;

import io.github.mmm.property.criteria.Literal;
import io.github.mmm.value.CriteriaObject;
import io.github.mmm.value.PropertyPath;
import java.util.Objects;

public class PropertyAssignment<V> {
    public static final PropertyAssignment<?>[] EMPTY_ARRAY = new PropertyAssignment[0];
    private final PropertyPath<V> property;
    private final CriteriaObject<V> value;

    PropertyAssignment(PropertyPath<V> property, CriteriaObject<V> value) {
        Objects.requireNonNull(property, "property");
        this.property = property;
        this.value = value;
    }

    public PropertyPath<V> getProperty() {
        return this.property;
    }

    public CriteriaObject<V> getValue() {
        return this.value;
    }

    public String toString() {
        String v = this.value instanceof PropertyPath ? ((PropertyPath)this.value).path() : Objects.toString(this.value);
        return this.property.path() + "=" + v;
    }

    public static <V> PropertyAssignment<V> of(PropertyPath<V> property, V value) {
        return PropertyAssignment.of(property, Literal.of(value));
    }

    public static <V> PropertyAssignment<V> of(PropertyPath<V> property, CriteriaObject<V> value) {
        return new PropertyAssignment<V>(property, value);
    }

    public static <V> PropertyAssignment<V> ofValue(PropertyPath<V> property) {
        return PropertyAssignment.of(property, property.get());
    }

    public static <V> PropertyAssignment<V>[] ofValues(PropertyPath<V> ... properties) {
        PropertyAssignment[] assignments = new PropertyAssignment[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            assignments[i] = PropertyAssignment.ofValue(properties[i]);
        }
        return assignments;
    }
}

