/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.criteria;

import io.github.mmm.value.ReadablePath;
import io.github.mmm.value.SimplePath;
import io.github.mmm.value.WritablePath;

public final class PropertyPathHelper {
    private PropertyPathHelper() {
    }

    public static boolean isEqualPath(ReadablePath path1, ReadablePath path2) {
        return PropertyPathHelper.isEqualPath(path1, path2, false);
    }

    public static boolean isEqualPath(ReadablePath path1, ReadablePath path2, boolean ignorePath1Alias) {
        if (path2 == null || path1 == null) {
            if (ignorePath1Alias && path1 instanceof SimplePath && path1.parentPath() == null) {
                return true;
            }
            return path2 == path1;
        }
        if (!path1.pathSegment().equals(path2.pathSegment())) {
            return false;
        }
        return PropertyPathHelper.isEqualPath(PropertyPathHelper.getParent(path1), PropertyPathHelper.getParent(path2), ignorePath1Alias);
    }

    public static ReadablePath getParent(ReadablePath path) {
        if (path == null) {
            return null;
        }
        ReadablePath parent = path.parentPath();
        if (parent instanceof WritablePath) {
            return parent.parentPath();
        }
        return parent;
    }
}

