/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.criteria;

import io.github.mmm.base.filter.CharFilter;
import io.github.mmm.scanner.CharScannerParser;
import io.github.mmm.scanner.CharStreamScanner;
import io.github.mmm.value.PropertyPath;
import io.github.mmm.value.ReadablePath;

public interface PropertyPathParser
extends CharScannerParser<PropertyPath<?>> {
    default public PropertyPath<?> parse(CharStreamScanner scanner) {
        return this.parse(scanner, null);
    }

    public PropertyPath<?> parse(CharStreamScanner var1, String var2);

    public static String parseSegment(CharStreamScanner scanner) {
        return PropertyPathParser.parseSegment(scanner, null);
    }

    public static String parseSegment(CharStreamScanner scanner, PropertyPath<?> path) {
        String segment = scanner.readWhile(CharFilter.SEGMENT, 1, 256);
        if (segment == null || segment.isEmpty()) {
            if (path != null) {
                throw new IllegalArgumentException("Expected path segment not found at " + String.valueOf(path) + ".");
            }
            throw new IllegalArgumentException("Expected path segment not found.");
        }
        return segment;
    }

    public static String readSegment(CharStreamScanner scanner, ReadablePath path) {
        String segment = scanner.readWhile(CharFilter.SEGMENT);
        if (segment == null || segment.isEmpty()) {
            if (path != null) {
                throw new IllegalArgumentException("Expected path segment not found at " + String.valueOf(path) + ".");
            }
            throw new IllegalArgumentException("Expected path segment not found.");
        }
        return segment;
    }
}

