/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.criteria.impl;

import io.github.mmm.property.criteria.BooleanSelection;
import io.github.mmm.property.criteria.CriteriaPredicate;
import io.github.mmm.property.criteria.PredicateOperator;
import io.github.mmm.property.criteria.impl.AbstractCriteriaPredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConjunctionPredicate
extends AbstractCriteriaPredicate {
    private final List<BooleanSelection> args;

    public ConjunctionPredicate(PredicateOperator operator, BooleanSelection ... args) {
        this(List.of(args), operator);
    }

    public ConjunctionPredicate(PredicateOperator operator, List<BooleanSelection> args) {
        this(Collections.unmodifiableList(args), operator);
    }

    private ConjunctionPredicate(List<BooleanSelection> args, PredicateOperator operator) {
        super(operator);
        if (!operator.isConjunction()) {
            throw new IllegalArgumentException(String.valueOf(operator));
        }
        assert (!args.isEmpty());
        this.args = args;
    }

    public BooleanSelection getFirstArg() {
        if (this.args.size() > 0) {
            return this.args.get(0);
        }
        return null;
    }

    public BooleanSelection getSecondArg() {
        if (this.args.size() > 1) {
            return this.args.get(1);
        }
        return null;
    }

    @Override
    public List<BooleanSelection> getArgs() {
        return this.args;
    }

    @Override
    public CriteriaPredicate not() {
        return new ConjunctionPredicate(this.operator.not(), this.args);
    }

    @Override
    public CriteriaPredicate simplify() {
        List<BooleanSelection> newArgs = null;
        int size = this.args.size();
        for (int i = 0; i < size; ++i) {
            BooleanSelection arg = this.args.get(i);
            BooleanSelection simplified = arg.simplify();
            if (simplified instanceof ConjunctionPredicate && this.operator == ((ConjunctionPredicate)simplified).operator) {
                newArgs = this.copyArgs(newArgs, i);
                newArgs.addAll(((ConjunctionPredicate)simplified).getArgs());
                continue;
            }
            if (simplified == arg) continue;
            newArgs = this.copyArgs(newArgs, i);
            newArgs.add(simplified);
        }
        if (newArgs == null) {
            return this;
        }
        return new ConjunctionPredicate(this.operator, newArgs);
    }

    private List<BooleanSelection> copyArgs(List<BooleanSelection> newArgs, int limit) {
        if (newArgs == null) {
            newArgs = new ArrayList<BooleanSelection>(this.args.size() + 2);
            for (int i = 0; i < limit; ++i) {
                newArgs.add(this.args.get(i));
            }
        }
        return newArgs;
    }
}

