/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.criteria.impl;

import io.github.mmm.property.criteria.Literal;
import io.github.mmm.property.criteria.impl.BooleanLiteralImpl;
import io.github.mmm.property.criteria.impl.StringLiteral;
import java.util.Objects;
import java.util.function.Supplier;

public class GenericLiteral<V>
implements Literal<V> {
    private final V value;

    public GenericLiteral(V value) {
        Objects.requireNonNull(value);
        this.value = value;
    }

    @Override
    public V get() {
        return this.value;
    }

    public String toString() {
        return this.toString(this.value);
    }

    private String toString(Object literalValue) {
        if (literalValue == null) {
            return "null";
        }
        if (literalValue instanceof Supplier) {
            return this.toString(((Supplier)literalValue).get());
        }
        if (literalValue instanceof Boolean) {
            return BooleanLiteralImpl.toString((Boolean)literalValue);
        }
        if (literalValue instanceof Number) {
            return literalValue.toString();
        }
        return StringLiteral.toString(this.value.toString());
    }
}

