/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.criteria.impl;

import io.github.mmm.property.criteria.BooleanLiteral;
import io.github.mmm.property.criteria.CriteriaPredicate;
import io.github.mmm.property.criteria.PredicateOperator;
import io.github.mmm.property.criteria.impl.AbstractCriteriaPredicate;
import io.github.mmm.value.CriteriaObject;
import java.util.List;

public class SimplePredicate
extends AbstractCriteriaPredicate {
    public static final SimplePredicate ALWAYS = new SimplePredicate(BooleanLiteral.TRUE, PredicateOperator.EQ, BooleanLiteral.TRUE);
    public static final SimplePredicate NEVER = new SimplePredicate(BooleanLiteral.TRUE, PredicateOperator.EQ, BooleanLiteral.FALSE);
    private final CriteriaObject<?> arg1;
    private final CriteriaObject<?> arg2;

    public SimplePredicate(CriteriaObject<?> arg1, PredicateOperator operator, CriteriaObject<?> arg2) {
        super(operator);
        if (operator.isConjunction()) {
            throw new IllegalStateException(operator.toString());
        }
        this.arg1 = arg1;
        this.arg2 = arg2;
        assert (arg2 == null == operator.isUnary());
    }

    @Override
    public CriteriaObject<?> getFirstArg() {
        return this.arg1;
    }

    @Override
    public CriteriaObject<?> getSecondArg() {
        return this.arg2;
    }

    @Override
    public List<? extends CriteriaObject<?>> getArgs() {
        if (this.arg2 == null) {
            return List.of(this.arg1);
        }
        return List.of(this.arg1, this.arg2);
    }

    @Override
    public int getArgCount() {
        if (this.arg2 == null) {
            return 1;
        }
        return 2;
    }

    @Override
    public CriteriaPredicate not() {
        if (this == ALWAYS) {
            return NEVER;
        }
        if (this == NEVER) {
            return ALWAYS;
        }
        PredicateOperator inverseOperator = this.operator.not();
        if (inverseOperator == null) {
            if (this.operator == PredicateOperator.NOT && this.arg2 == null && this.arg1 instanceof CriteriaPredicate) {
                return (CriteriaPredicate)this.arg1;
            }
            return null;
        }
        return new SimplePredicate(this.arg1, inverseOperator, this.arg2);
    }

    @Override
    public CriteriaPredicate simplify() {
        if (this.operator == PredicateOperator.NOT) {
            assert (this.arg2 == null);
            if (this.arg1 instanceof CriteriaPredicate) {
                return ((CriteriaPredicate)this.arg1).not();
            }
        }
        return this;
    }
}

