/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.enumeration;

import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.enumeration.WritableEnumProperty;
import io.github.mmm.property.object.SimpleProperty;
import java.util.Objects;

public class EnumProperty<E extends Enum<E>>
extends SimpleProperty<E>
implements WritableEnumProperty<E> {
    private Class<E> valueClass;
    private E value;

    public EnumProperty(String name) {
        this(name, null, (PropertyMetadata)null);
    }

    public EnumProperty(String name, PropertyMetadata<E> metadata) {
        this(name, metadata, (Class<E>)null);
    }

    public EnumProperty(String name, E value) {
        this(name, value, null);
    }

    public EnumProperty(String name, E value, PropertyMetadata<E> metadata) {
        super(name, metadata);
        Objects.requireNonNull(value);
        this.value = value;
        this.valueClass = this.value.getClass();
    }

    public EnumProperty(String name, PropertyMetadata<E> metadata, Class<E> valueClass) {
        super(name, metadata);
        this.valueClass = valueClass;
    }

    public Class<E> getValueClass() {
        if (this.valueClass == null && this.value != null) {
            this.valueClass = this.value.getClass();
        }
        return this.valueClass;
    }

    protected E doGet() {
        return this.value;
    }

    protected void doSet(E newValue) {
        this.value = this.valueClass != null && newValue != null ? (Enum)this.valueClass.cast(newValue) : newValue;
    }
}

