/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.factory;

import io.github.mmm.base.exception.ObjectNotFoundException;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.WritableProperty;
import io.github.mmm.property.factory.AbstractSimplePropertyFactory;
import io.github.mmm.property.factory.PropertyFactory;
import io.github.mmm.property.factory.PropertyTypeInfo;
import io.github.mmm.property.impl.PropertyFactoryManagerImpl;
import io.github.mmm.property.impl.metadata.PropertyMetadataNone;
import java.util.Set;

public interface PropertyFactoryManager {
    default public <V> WritableProperty<V> create(Class<V> valueClass, String name) {
        return this.create(null, valueClass, name);
    }

    default public <V> WritableProperty<V> create(Class<V> valueClass, String name, PropertyMetadata<V> metadata) {
        return this.create(null, valueClass, name, metadata);
    }

    default public <V, P extends WritableProperty<V>> P create(Class<P> propertyType, Class<V> valueClass, String name) {
        return this.create(propertyType, valueClass, name, PropertyMetadataNone.get());
    }

    default public <V, P extends WritableProperty<V>> P create(Class<P> propertyType, Class<V> valueClass, String name, PropertyMetadata<V> metadata) {
        PropertyFactory<V, P> factory = this.getRequiredFactory(propertyType, valueClass);
        if (factory instanceof AbstractSimplePropertyFactory) {
            AbstractSimplePropertyFactory simpleFactory = (AbstractSimplePropertyFactory)factory;
            return simpleFactory.create(name, metadata);
        }
        return factory.create(name, PropertyTypeInfo.ofValueClass(valueClass), metadata);
    }

    default public <V, P extends WritableProperty<V>> P create(Class<P> propertyType, PropertyTypeInfo<V> typeInfo, String name, PropertyMetadata<V> metadata) {
        PropertyFactory<V, P> factory = this.getRequiredFactory(propertyType, typeInfo.getValueClass());
        return factory.create(name, typeInfo, metadata);
    }

    public <V, P extends WritableProperty<V>> PropertyFactory<V, ? extends P> getFactoryForPropertyType(Class<P> var1);

    public <V> PropertyFactory<V, ? extends WritableProperty<V>> getFactoryForValueType(Class<? extends V> var1);

    default public <V, P extends WritableProperty<V>> PropertyFactory<V, ? extends P> getFactory(Class<P> propertyType, Class<V> valueType) {
        PropertyFactory<V, WritableProperty<V>> valueFactory;
        PropertyFactory<V, Object> factory = null;
        if (propertyType != null) {
            factory = this.getFactoryForPropertyType(propertyType);
        }
        if (!(valueType == null || factory != null && factory.getValueClass() != null || (valueFactory = this.getFactoryForValueType(valueType)) == null || propertyType != null && !propertyType.isAssignableFrom(valueFactory.getImplementationClass()))) {
            factory = valueFactory;
        }
        return factory;
    }

    default public <V, P extends WritableProperty<V>> PropertyFactory<V, ? extends P> getRequiredFactory(Class<P> propertyType, Class<V> valueType) {
        PropertyFactory<V, P> factory = this.getFactory(propertyType, valueType);
        if (factory == null) {
            Class<Object> type = propertyType;
            if (type == null) {
                type = valueType;
            }
            throw new ObjectNotFoundException((Object)"PropertyFactory", type);
        }
        return factory;
    }

    public Set<Class<?>> getValueTypes();

    public static PropertyFactoryManager get() {
        return PropertyFactoryManagerImpl.INSTANCE;
    }
}

