/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.impl;

import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.ReadableProperty;
import io.github.mmm.property.WritableProperty;
import io.github.mmm.property.factory.PropertyFactory;
import io.github.mmm.property.factory.PropertyFactoryManager;
import io.github.mmm.property.factory.PropertyTypeInfo;
import io.github.mmm.property.factory.SimplePropertyFactory;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;

public class PropertyFactoryManagerImpl
implements PropertyFactoryManager {
    public static final PropertyFactoryManagerImpl INSTANCE = new PropertyFactoryManagerImpl();
    private static final Map<Class<?>, Class<?>> PRIMITIVE2WRAPPER_MAP = Map.of(Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Short.TYPE, Short.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class);
    private final Map<Class<?>, PropertyFactory<?, ?>> propertyType2factoryMap = new HashMap();
    private final Map<Class<?>, PropertyFactory<?, ?>> valueType2factoryMap = new HashMap();
    private final List<PropertyFactory<?, ?>> polymorphicFactories = new ArrayList();

    protected PropertyFactoryManagerImpl() {
        ServiceLoader<PropertyFactory> serviceLoader = ServiceLoader.load(PropertyFactory.class);
        for (PropertyFactory factory : serviceLoader) {
            this.registerFactory(factory);
        }
        if (this.valueType2factoryMap.isEmpty()) {
            throw new IllegalStateException("No PropertyFactory available!");
        }
    }

    public void registerFactory(PropertyFactory<?, ?> factory) {
        this.registerFactory(factory, false);
    }

    protected void registerFactory(PropertyFactory<?, ?> factory, boolean allowOverride) {
        Class<?> implementationClass;
        Class<WritableProperty<?>> writableInterface;
        Class<ReadableProperty<?>> readableInterface = factory.getReadableInterface();
        if (readableInterface != null && readableInterface != ReadableProperty.class) {
            this.registerPropertyType(readableInterface, factory, allowOverride);
        }
        if ((writableInterface = factory.getWritableInterface()) != null && writableInterface != WritableProperty.class) {
            this.registerPropertyType(writableInterface, factory, allowOverride);
        }
        if ((implementationClass = factory.getImplementationClass()) == null) {
            Objects.requireNonNull(implementationClass, factory.getClass().getName() + ".getImplementationClass()");
        }
        this.registerPropertyType(implementationClass, factory, allowOverride);
        Class<?> valueClass = factory.getValueClass();
        if (valueClass != null) {
            this.registerValueType(valueClass, factory, allowOverride);
        }
        if (factory.isPolymorphic()) {
            this.registerPolymorphicFactory(factory);
        }
    }

    private void registerPolymorphicFactory(PropertyFactory<?, ?> factory) {
        int index = 0;
        Class<?> valueClass = factory.getValueClass();
        for (int i = 0; i < this.polymorphicFactories.size(); ++i) {
            PropertyFactory<?, ?> existingFactory = this.polymorphicFactories.get(i);
            if (!valueClass.isAssignableFrom(existingFactory.getValueClass())) continue;
            index = i + 1;
        }
        this.polymorphicFactories.add(index, factory);
    }

    private void registerValueType(Class<?> type, PropertyFactory<?, ?> factory, boolean allowOverride) {
        PropertyFactoryManagerImpl.register(this.valueType2factoryMap, type, factory, allowOverride);
    }

    private void registerPropertyType(Class<?> type, PropertyFactory<?, ?> factory, boolean allowOverride) {
        PropertyFactoryManagerImpl.register(this.propertyType2factoryMap, type, factory, allowOverride);
    }

    private static void register(Map<Class<?>, PropertyFactory<?, ?>> map, Class<?> type, PropertyFactory<?, ?> factory, boolean allowOverride) {
        if (type == null) {
            return;
        }
        PropertyFactory<?, ?> old = map.put(type, factory);
        if (old != null && !allowOverride) {
            throw new IllegalArgumentException("Duplicate PojoFactory " + String.valueOf(factory) + " for " + String.valueOf(type) + " already having " + String.valueOf(old));
        }
    }

    public <V, PROPERTY extends WritableProperty<V>> PropertyFactory<V, ? extends PROPERTY> getFactoryForPropertyType(Class<PROPERTY> propertyType) {
        PropertyFactory<?, ?> factory = this.propertyType2factoryMap.get(propertyType);
        if (factory == null && !Modifier.isAbstract(propertyType.getModifiers())) {
            factory = new SimplePropertyFactory(propertyType);
        }
        return factory;
    }

    @Override
    public <V> PropertyFactory<V, ? extends WritableProperty<V>> getFactoryForValueType(Class<? extends V> valueClass) {
        PropertyFactory<?, ?> factory;
        if (valueClass.isPrimitive()) {
            valueClass = PRIMITIVE2WRAPPER_MAP.get(valueClass);
        }
        if ((factory = this.valueType2factoryMap.get(valueClass)) == null) {
            for (PropertyFactory<?, ?> polymorphicFactory : this.polymorphicFactories) {
                if (!polymorphicFactory.getValueClass().isAssignableFrom(valueClass)) continue;
                factory = polymorphicFactory;
                break;
            }
        }
        return factory;
    }

    @Override
    public Set<Class<?>> getValueTypes() {
        return Collections.unmodifiableSet(this.valueType2factoryMap.keySet());
    }

    public <V, PROPERTY extends WritableProperty<V>> PROPERTY create(Class<PROPERTY> propertyType, PropertyTypeInfo<V> typeInfo, String name, PropertyMetadata<V> metadata) {
        PropertyFactory<V, PROPERTY> factory = this.getRequiredFactory(propertyType, typeInfo.getValueClass());
        return factory.create(name, typeInfo, metadata);
    }
}

