/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.impl.metadata;

import io.github.mmm.base.metainfo.MetaInfo;
import io.github.mmm.property.AbstractPropertyMetadata;
import io.github.mmm.property.AttributeReadOnly;
import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.impl.metadata.PropertyMetadataExpression;
import io.github.mmm.property.impl.metadata.PropertyMetadataInfo;
import io.github.mmm.property.impl.metadata.PropertyMetadataNone;
import io.github.mmm.property.impl.metadata.PropertyMetadataValidator;
import io.github.mmm.property.impl.readonly.AttributeNeverReadOnly;
import io.github.mmm.validation.Validator;
import java.util.function.Supplier;

public class PropertyMetadataLock<V>
extends AbstractPropertyMetadata<V> {
    protected final AttributeReadOnly lock;

    public PropertyMetadataLock(AttributeReadOnly lock) {
        this.lock = lock == null ? AttributeNeverReadOnly.INSTANCE : lock;
    }

    @Override
    public AttributeReadOnly getLock() {
        return this.lock;
    }

    @Override
    public PropertyMetadata<V> withLock(AttributeReadOnly newLock) {
        if (newLock != this.lock) {
            if (newLock == null || newLock == AttributeNeverReadOnly.INSTANCE) {
                return PropertyMetadataNone.get();
            }
            return new PropertyMetadataLock<V>(newLock);
        }
        return this;
    }

    @Override
    public PropertyMetadata<V> withValidator(Validator<? super V> newValidator) {
        if (Validator.isValidating(newValidator)) {
            return new PropertyMetadataValidator<V>(this.lock, newValidator);
        }
        return this;
    }

    @Override
    public PropertyMetadata<V> withExpression(Supplier<? extends V> newExpression) {
        if (newExpression != null) {
            return new PropertyMetadataExpression<V>(this.lock, null, newExpression);
        }
        return this;
    }

    @Override
    public PropertyMetadata<V> withMetaInfo(MetaInfo metaInfo) {
        if (metaInfo != null && !metaInfo.isEmpty()) {
            return new PropertyMetadataInfo(this.lock, null, null, metaInfo);
        }
        return this;
    }
}

