/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.object;

import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.object.SimpleProperty;
import io.github.mmm.property.object.WritableObjectProperty;
import java.util.Objects;

public class ObjectProperty<V>
extends SimpleProperty<V>
implements WritableObjectProperty<V> {
    private final Class<V> valueClass;
    private V value;

    public ObjectProperty(String name, Class<V> valueClass) {
        this(name, valueClass, (PropertyMetadata<Class<V>>)null);
    }

    public ObjectProperty(String name, Class<V> valueClass, PropertyMetadata<V> metadata) {
        super(name, metadata);
        Objects.requireNonNull(valueClass);
        this.valueClass = valueClass;
    }

    public ObjectProperty(String name, V value) {
        this(name, value, null);
    }

    public ObjectProperty(String name, V value, PropertyMetadata<V> metadata) {
        super(name, metadata);
        Objects.requireNonNull(value);
        this.valueClass = value.getClass();
        this.doSet(value);
    }

    public Class<V> getValueClass() {
        return this.valueClass;
    }

    protected V doGet() {
        return this.value;
    }

    protected void doSet(V newValue) {
        assert (this.valueClass.isInstance(newValue));
        this.value = newValue;
    }

    public V parse(String valueAsString) {
        throw new UnsupportedOperationException();
    }

    public V getFallbackSafeValue() {
        return null;
    }
}

