/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.property.pattern;

import io.github.mmm.property.PropertyMetadata;
import io.github.mmm.property.object.SimpleProperty;
import io.github.mmm.property.pattern.WritablePatternProperty;
import io.github.mmm.property.string.StringProperty;
import java.util.regex.Pattern;

public class PatternProperty
extends SimpleProperty<Pattern>
implements WritablePatternProperty {
    private Pattern value;

    public PatternProperty(String name) {
        this(name, null, null);
    }

    public PatternProperty(String name, PropertyMetadata<Pattern> metadata) {
        this(name, null, metadata);
    }

    public PatternProperty(String name, Pattern value) {
        this(name, value, null);
    }

    public PatternProperty(String name, Pattern value, PropertyMetadata<Pattern> metadata) {
        super(name, metadata);
        this.value = value;
    }

    protected Pattern doGet() {
        return this.value;
    }

    protected void doSet(Pattern newValue) {
        this.value = newValue;
    }

    public Pattern parse(String valueAsString) {
        return Pattern.compile(valueAsString);
    }

    public StringProperty asString() {
        return new PatternStringProperty(this.getName() + ".string");
    }

    private class PatternStringProperty
    extends StringProperty {
        public PatternStringProperty(String name) {
            super(name);
        }

        @Override
        protected String doGet() {
            return PatternProperty.this.getAsString();
        }

        @Override
        protected void doSet(String newValue) {
            PatternProperty.this.set(Pattern.compile(newValue));
        }
    }
}

